package cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentConfigReq;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentConfigRes;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentReq;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 获取  jsapi 票据 工具类
 */
public class JsapiTicketUtil {
    private static Logger logger = LoggerFactory.getLogger(JsapiTicketUtil.class);


    /**
     * 获取企业的jsapi_ticket。 <br/>
     * 需要在该应用下，配置企业可信IP;
     *
     * @param agentToken 应用令牌
     * @param req        请求体
     * @return 响应结果
     */
    public static JsapiTicketForAgentRes getJsapiTicketForAgent(String agentToken, JsapiTicketForAgentReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("获取企业的jsapi_ticket: ");

        req.setReqBody(null);
        JsapiTicketForAgentRes res = new JsapiTicketForAgentRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 获取应用的jsapi_ticket。 <br/>
     * 需要在该应用下，配置企业可信IP;
     *
     * @param agentToken 应用令牌
     * @param req        请求体
     * @return 响应结果
     */
    public static JsapiTicketForAgentConfigRes getJsapiTicketForAgentConfig(String agentToken, JsapiTicketForAgentConfigReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("获取应用的jsapi_ticket: ");

        req.setReqBody(null);
        JsapiTicketForAgentConfigRes res = new JsapiTicketForAgentConfigRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=ACCESS_TOKEN&type=agent_config";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.get(msgPre, url, req, res, null);
    }
}
