package cn.net.wanmo.common.weixin.work.inner.pojo;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;

import java.io.Serializable;

/**
 * 企业信息
 */
public class Corp<AddressBookToken extends AccessToken> implements Serializable {
    /** 企业 corpId */
    private String corpId;
    /** 企业名称 */
    private String title;
    /** 企业描述 */
    private String desc;
    /** 通讯录密钥 */
    private String addressBookSecret;
    /** 通讯录令牌 */
    private AddressBookToken addressBookToken;
    /** 日志打印描述 */
    private String logPrevDesc;

    public Corp() {
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAddressBookSecret() {
        return addressBookSecret;
    }

    public void setAddressBookSecret(String addressBookSecret) {
        this.addressBookSecret = addressBookSecret;
    }

    public AddressBookToken getAddressBookToken() {
        return addressBookToken;
    }

    public void setAddressBookToken(AddressBookToken addressBookToken) {
        this.addressBookToken = addressBookToken;
    }

    public String getLogPrevDesc() {
        if (StringUtil.isBlank(logPrevDesc)) {
            return title;
        }

        return logPrevDesc;
    }

    public void setLogPrevDesc(String logPrevDesc) {
        this.logPrevDesc = logPrevDesc;
    }
    /**
     * 获取访问令牌
     * @return 访问令牌
     */
    public String takeTokenForAddressBook() {
        if (addressBookToken == null) {
            return null;
        }

        addressBookToken.setCorpId(corpId);
        return addressBookToken.takeToken();
    }
}
