package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.department.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson.JSONObject;

public class DeptUpdateReq extends BaseReq {
    /**
     * 生成请求体
     *
     * @param dept 部门信息
     * @return 请求体
     */
    public static DeptUpdateReq build(Dept dept) {
        DeptUpdateReq req = new DeptUpdateReq();
        req.setDept(dept);
        return req;
    }


    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();

        params.put("id", dept.getId());
        params.put("name", dept.getName());
        params.put("name_en", dept.getNameEn());
        params.put("parentid", dept.getParentId());
        params.put("order", dept.getOrder());

        return params.toJSONString();
    }

    // ===============================================================================
    private Dept dept;

    public DeptUpdateReq() {
        this.dept = new Dept();
    }

    public Dept getDept() {
        return dept;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
    }

    // ===============================================================================
    public Dept newDept() {
        return new Dept();
    }

    public class Dept {
        /**
         * 是	部门id
         */
        private String id;
        /**
         * 否	父部门id
         */
        private String parentId;
        /**
         * 否	部门名称。长度限制为1~64个UTF-8字符，字符不能包括\:*?"<>｜
         */
        private String name;
        /**
         * 否	英文名称，需要在管理后台开启多语言支持才能生效。长度限制为1~64个字符，字符不能包括\:*?"<>｜
         */
        private String nameEn;
        /**
         * 否	在父部门中的次序值。order值大的排序靠前。有效的值范围是[0, 2^32)
         */
        private int order;

        public Dept() {
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentId() {
            return parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameEn() {
            return nameEn;
        }

        public void setNameEn(String nameEn) {
            this.nameEn = nameEn;
        }

        public int getOrder() {
            return order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }
}
