package cn.net.wanmo.common.weixin.work.inner.server_api.material.pojo;

import cn.net.wanmo.common.send.BaseReq;
import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UploadTemporaryReq extends BaseReq {

    public static UploadTemporaryReq build(Type type,String filename, File file) {
        UploadTemporaryReq req = new UploadTemporaryReq();
        {
            req.setType(type);
            req.setFilename(filename);
            req.setFileLength(file.length());
            req.setFile(file);
        }

        req.setReqFile(req.newReqFile("media", file, filename));
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        return params.toJSONString();
    }

    /** 媒体文件类型，分别有图片（image）、语音（voice）、视频（video），普通文件(file) */
    private Type type;
    /** 文件名 */
    private String filename;
    /** 请求体内容大小 */
    private Long fileLength;
    /** 文件 */
    private File file;

    public UploadTemporaryReq() {
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Long getFileLength() {
        return fileLength;
    }

    public void setFileLength(Long fileLength) {
        this.fileLength = fileLength;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public enum Type {
        image("image", "图片"),
        voice("voice", "语音"),
        video("video", "视频"),
        file("file", "普通文件");

        private final String value;
        private final String label;

        Type(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public static Type get(String value) {
            if (StringUtil.equals(image.getValue(), value)) {
                return image;
            }
            if (StringUtil.equals(voice.getValue(), value)) {
                return voice;
            }
            if (StringUtil.equals(video.getValue(), value)) {
                return video;
            }
            if (StringUtil.equals(file.getValue(), value)) {
                return file;
            }

            return null;
        }

    }
}
