package cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo;

import cn.net.wanmo.common.send.BaseReq;

import java.io.Serializable;

/**
 * 注：toUser、toParty、toTag不能同时为空
 */
public abstract class MessageReq extends BaseReq {
    /** 指定接收消息的成员，成员ID列表（多个接收者用‘|’分隔，最多支持1000个）。 <br/>特殊情况：指定为"@all"，则向该企业应用的全部成员发送 */
    protected String toUser;
    /** 指定接收消息的部门，部门ID列表，多个接收者用‘|’分隔，最多支持100个。 <br/> 当toUser为"@all"时忽略本参数 */
    protected String toParty;
    /** 指定接收消息的标签，标签ID列表，多个接收者用‘|’分隔，最多支持100个。<br/> 当toUser为"@all"时忽略本参数 */
    protected String toTag;
    /** 消息类型 */
    protected MsgType msgType;
    /** 企业应用的id，整型。企业内部开发，可在应用的设置页面查看；第三方服务商，可通过接口 获取企业授权信息 获取该参数值 */
    protected String agentId;
    /** 表示是否是保密消息，0表示可对外分享，1表示不能分享且内容显示水印，默认为0 */
    protected Integer safe;
    /** 表示是否开启id转译，0表示否，1表示是，默认0。仅第三方应用需要用到，企业自建应用可以忽略。 */
    protected Integer enableIdTrans;
    /** 表示是否开启重复消息检查，0表示否，1表示是，默认0 */
    protected Integer enableDuplicateCheck;
    /** 表示是否重复消息检查的时间间隔，默认1800s，最大不超过4小时 */
    protected Integer duplicateCheckInterval;

    public MessageReq() {
    }


    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public String getToParty() {
        return toParty;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }

    public String getToTag() {
        return toTag;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public MsgType getMsgType() {
        return msgType;
    }

    public void setMsgType(MsgType msgType) {
        this.msgType = msgType;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public Integer getSafe() {
        return safe;
    }

    public void setSafe(Integer safe) {
        this.safe = safe;
    }

    public Integer getEnableIdTrans() {
        return enableIdTrans;
    }

    public void setEnableIdTrans(Integer enableIdTrans) {
        this.enableIdTrans = enableIdTrans;
    }

    public Integer getEnableDuplicateCheck() {
        return enableDuplicateCheck;
    }

    public void setEnableDuplicateCheck(Integer enableDuplicateCheck) {
        this.enableDuplicateCheck = enableDuplicateCheck;
    }

    public Integer getDuplicateCheckInterval() {
        return duplicateCheckInterval;
    }

    public void setDuplicateCheckInterval(Integer duplicateCheckInterval) {
        this.duplicateCheckInterval = duplicateCheckInterval;
    }

    public enum MsgType{
        text("text", "文本消息"),
        image("image", "图片消息"),
        voice("voice", "语音消息"),
        video("video", "视频消息"),
        file("file", "文件消息"),
        textcard("textcard", "文本卡片消息"),
        news("news", "图文消息"),
        mpnews("mpnews", "图文消息"),
        markdown("markdown", "markdown消息"),
        miniprogram_notice("miniprogram_notice", "小程序通知消息"),
        template_card("template_card", "模板卡片消息（文本通知型：[card_type : text_notice], 图文展示型：[card_type : news_notice], 按钮交互型：[card_type : button_interaction], 投票选择型：[card_type : vote_interaction], 多项选择型：[card_type : multiple_interaction]）");

        private final String value;
        private final String label;

        MsgType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

    }
}
