/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.storage;

import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.JsapiTicketUtil;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentConfigData;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentConfigReq;
import cn.net.wanmo.common.weixin.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentConfigRes;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.pojo.log.TokenLog;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.TicketToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketTokenForAgentConfig {
    private static Logger logger = LoggerFactory.getLogger(TicketTokenForAgentConfig.class);
    private static Map<String, TicketToken> ticketMap = new HashMap<String, TicketToken>();

    private static String getMapKey(String corpId, String agentId) {
        return corpId + ":" + agentId;
    }

    public static <TicketTokenAgentConfig extends TicketToken> void putTicket(String corpId, String agentId, TicketTokenAgentConfig ticketTokenAgentConfig) {
        ticketTokenAgentConfig.storeToken();
        ticketMap.put(TicketTokenForAgentConfig.getMapKey(corpId, agentId), ticketTokenAgentConfig);
    }

    public static TicketToken getTicket(String corpId, String agentId) {
        return ticketMap.getOrDefault(TicketTokenForAgentConfig.getMapKey(corpId, agentId), new TicketToken());
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> JsapiTicketForAgentConfigRes initToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent) {
        return TicketTokenForAgentConfig.initToken(agent, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, TicketTokenAgentConfig extends TicketToken> JsapiTicketForAgentConfigRes initToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, TicketTokenAgentConfig ticketTokenAgentConfig) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentToken = agent.takeToken();
        return TicketTokenForAgentConfig.initToken(corpId, agentId, agentToken, ticketTokenAgentConfig);
    }

    public static <AgentToken extends AccessToken> JsapiTicketForAgentConfigRes initToken(String corpId, String agentId, String agentToken) {
        return TicketTokenForAgentConfig.initToken(corpId, agentId, agentToken, null);
    }

    public static <AgentToken extends AccessToken, TicketTokenAgentConfig extends TicketToken> JsapiTicketForAgentConfigRes initToken(String corpId, String agentId, String agentToken, TicketTokenAgentConfig ticketTokenAgentConfig) {
        JsapiTicketForAgentConfigReq req = JsapiTicketForAgentConfigReq.build();
        JsapiTicketForAgentConfigRes result = JsapiTicketUtil.getJsapiTicketForAgentConfig(agentToken, req);
        TicketToken ticketToken = new TicketToken();
        ticketToken.setCorpId(corpId);
        ticketToken.setAgentId(agentId);
        ticketToken.setTokenType(TicketToken.TokenType.jsapi_ticket_config);
        ticketToken.setCode(String.valueOf(result.getErrCode()));
        ticketToken.setMsg(result.getErrMsg());
        ticketToken.setResTime(result.getResTime());
        if (result.isSuccess()) {
            JsapiTicketForAgentConfigData data = (JsapiTicketForAgentConfigData)result.getData();
            ticketToken.setValue(data.getTicket());
            ticketToken.setExpiresIn(data.getExpiresIn());
        }
        if (Objects.isNull(ticketTokenAgentConfig)) {
            TicketTokenForAgentConfig.putTicket(corpId, agentId, ticketToken);
            logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u6267\u884c\u9ed8\u8ba4\u5b58\u50a8\u5e94\u7528 jsApiConfig \u7968\u636e\u4ee4\u724c\u5b8c\u6210 ...", (Object)agentId);
        } else {
            ticketTokenAgentConfig.setCorpId(ticketToken.getCorpId());
            ticketTokenAgentConfig.setAgentId(ticketToken.getAgentId());
            ticketTokenAgentConfig.setTokenType(ticketToken.getTokenType());
            ticketTokenAgentConfig.setCode(ticketToken.getCode());
            ticketTokenAgentConfig.setMsg(ticketToken.getMsg());
            ticketTokenAgentConfig.setValue(ticketToken.getValue());
            ticketTokenAgentConfig.setExpiresIn(ticketToken.getExpiresIn());
            ticketTokenAgentConfig.setResTime(ticketToken.getResTime());
            TicketTokenForAgentConfig.putTicket(corpId, agentId, ticketTokenAgentConfig);
            logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u6267\u884c\u81ea\u5b9a\u4e49\u5b58\u50a8\u5e94\u7528 jsApiConfig \u7968\u636e\u4ee4\u724c\u5b8c\u6210 ...", (Object)agentId);
        }
        TokenLog.put(corpId, agentId, ticketToken.getTokenType().getLabel(), ticketToken, TokenLog.ticketConfigTokenMap);
        return result;
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent) {
        TicketTokenForAgentConfig.runThreadInitToken(agent, null, null, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, Integer residueSecond, Integer waitSecond) {
        TicketTokenForAgentConfig.runThreadInitToken(agent, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, TicketTokenAgentConfig extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, TicketTokenAgentConfig ticketTokenAgentConfig) {
        TicketTokenForAgentConfig.runThreadInitToken(agent, null, null, ticketTokenAgentConfig);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, TicketTokenAgentConfig extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, Integer residueSecond, Integer waitSecond, TicketTokenAgentConfig ticketTokenAgentConfig) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentToken = agent.takeToken();
        TicketTokenForAgentConfig.runThreadInitToken(corpId, agentId, agentToken, residueSecond, waitSecond, ticketTokenAgentConfig);
    }

    public static <AgentToken extends AccessToken> void runThreadInitToken(String corpId, String agentId, String agentToken) {
        TicketTokenForAgentConfig.runThreadInitToken(corpId, agentId, agentToken, null, null, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitToken(String corpId, String agentId, String agentToken, Integer residueSecond, Integer waitSecond) {
        TicketTokenForAgentConfig.runThreadInitToken(corpId, agentId, agentToken, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken, TicketTokenAgentConfig extends TicketToken> void runThreadInitToken(String corpId, String agentId, String agentToken, TicketTokenAgentConfig ticketTokenAgentConfig) {
        TicketTokenForAgentConfig.runThreadInitToken(corpId, agentId, agentToken, null, null, ticketTokenAgentConfig);
    }

    public static <AgentToken extends AccessToken, TicketTokenAgentConfig extends TicketToken> void runThreadInitToken(final String corpId, final String agentId, final String agentToken, final Integer residueSecond, final Integer waitSecond, final TicketTokenAgentConfig ticketTokenAgentConfig) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            JsapiTicketForAgentConfigRes result;
                            if ((result = TicketTokenForAgentConfig.initToken(corpId, agentId, agentToken, ticketTokenAgentConfig)).isSuccess()) {
                                String ticketValue = ((JsapiTicketForAgentConfigData)result.getData()).getTicket();
                                Integer expiresIn = ((JsapiTicketForAgentConfigData)result.getData()).getExpiresIn();
                                logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u914d\u7f6e jsApiConfig \u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c ticket = {}", new Object[]{agentId, expiresIn, ticketValue});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u4f01\u4e1a\u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u914d\u7f6e jsApiConfig \u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{agentId, result.getErrCode(), result.getErrMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4f01\u4e1a\u5e94\u7528ID: " + agentId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u914d\u7f6ejsapi\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

