package cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.pojo.AccessTokenReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.pojo.AccessTokenRes;

public class AccessTokenUtil {

    /**
     * <br /> 为了安全考虑，开发者 请勿 将 access_token 返回给前端，需要开发者保存在后台，所有访问企业微信api的请求由后台发起。
     * <br />
     * <br /> 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取。
     *
     * @param corpId 企业ID
     * @param secret 通讯录密钥 或 应用密钥
     * @return 接口实际响应的结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken
     * </pre>
     */
    public static AccessTokenRes getAccessToken(String corpId, String secret) {
        AccessTokenReq req = new AccessTokenReq();
        req.setCorpId(corpId);
        req.setSecret(secret);
        return getAccessToken(req);
    }


    /**
     * <br /> 为了安全考虑，开发者 请勿 将 access_token 返回给前端，需要开发者保存在后台，所有访问企业微信api的请求由后台发起。
     * <br />
     * <br /> 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取。
     *
     * @param req 请求体
     * @return 接口实际响应的结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken
     * </pre>
     */
    public static AccessTokenRes getAccessToken(AccessTokenReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("企业微信接口 获取访问令牌: ");

        req.setReqBody(null);
        AccessTokenRes res = new AccessTokenRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=ID&corpsecret=SECRET";
        url = url.replace("ID", req.getCorpId()).replace("SECRET", req.getSecret());

        return SendUtil.get(msgPre, url, req, res, null);
    }
}
