package cn.net.wanmo.common.weixin.work.inner.server_api.material.pojo;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.enums.dict.DemoEnum;

import java.io.Serializable;

public class UploadTemporaryData implements Serializable {

    /**
     * 媒体文件类型，分别有图片（image）、语音（voice）、视频（video），普通文件(file)
     */
    private MediaType mediaType;
    /**
     * 媒体文件上传后获取的唯一标识，3天内有效
     */
    private String mediaId;
    /**
     * 媒体文件上传时间戳
     */
    private String createdAt;

    public UploadTemporaryData() {
    }

    public MediaType getMediaType() {
        return mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public enum MediaType {
        unknown("", "未知"),
        image("image", "图片"),
        voice("voice", "语音"),
        video("video", "视频"),
        file("file", "普通文件");

        private final String value;
        private final String label;

        MediaType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static MediaType changeOf(String value) {
            MediaType r = MediaType.unknown;

            MediaType[] values = MediaType.values();
            for (MediaType e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }

    }
}
