package cn.net.wanmo.common.weixin.work.inner.server_api.message;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo.MessageRecallReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo.MessageRecallRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo.MessageReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo.MessageRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 企业微信开放了消息发送接口，企业可以使用这些接口让自定义应用与企业微信后台或用户间进行双向通信。
 */
public class MessageUtil {
    private static Logger logger = LoggerFactory.getLogger(MessageUtil.class);


    /**
     * 应用支持推送文本、图片、视频、文件、图文等类型。 <br/>
     *
     * @param agentToken       应用令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static MessageRes sendMessage(String agentToken, MessageReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("消息推送 发送应用消息: ");

        req.setReqBody(req.toJSONString());
        MessageRes res = new MessageRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 本接口可以撤回24小时内通过发送应用消息接口推送的消息，仅可撤回企业微信端的数据，微信插件端的数据不支持撤回。 <br/>
     *
     * @param agentToken       应用令牌
     * @param msgId         消息ID
     * @return 响应结果
     */
    public static MessageRecallRes recallMessage(String agentToken, String msgId) {
        String msgPre = CommonUtil.getInterfaceTitle("消息撤回 撤回应用消息: ") ;

        MessageRecallReq req = MessageRecallReq.build(msgId);
        req.setReqBody(req.toJSONString());
        MessageRecallRes res = new MessageRecallRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/recall?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }
}
