package cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo;

import com.alibaba.fastjson.JSONObject;

/**
 * 视频消息 // TODO 视频消息待实现
 */
public class VideoMessageReq extends MessageReq {

    public static VideoMessageReq build(String agentId, String content) {
        VideoMessageReq req = new VideoMessageReq();
        req.setAgentId(agentId);
        req.getText().setContent(content);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("touser", getToUser());
        params.put("toparty", getToParty());
        params.put("totag", getToTag());
        params.put("msgtype", getMsgType().getValue());
        params.put("agentid", getAgentId());
        params.put("text", getText().toJSONObject());
        params.put("safe", getSafe());
        params.put("enable_id_trans", getEnableIdTrans());
        params.put("enable_duplicate_check", getEnableDuplicateCheck());
        params.put("duplicate_check_interval", getDuplicateCheckInterval());
        return params.toJSONString();
    }

    /** 消息内容 */
    private Text text;

    public VideoMessageReq() {
        this.msgType = MsgType.text;
        this.text = new Text();
    }

    public Text getText() {
        return text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public class Text {

        /** 消息内容，最长不超过2048个字节，超过将截断（支持id转译） */
        private String content;

        public Text() {
        }

        public Text(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }


        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("content", getContent());
            return object;
        }
    }
}
