package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.user;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.address_book.user.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 企业内部开发 -> 服务端API -> 通讯录管理 -> 成员管理 <br/>
 * <pre>
 *     1. 电脑端企业微信 -> 安全与管理 -> 管理工具 -> 通讯录同步 -> 开启;
 *     2. 查看 Secret;
 *     3. 企业可信IP配置;
 * </pre>
 */
public class UserUtil {
    private static Logger logger = LoggerFactory.getLogger(UserUtil.class);


    /**
     * 创建成员
     */
    public static UserCreateRes createUser(String addressBookToken, UserCreateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 创建成员: ");

        req.setBody(req.toBody());
        UserCreateRes res = new UserCreateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 读取成员 <br/>
     * 注： 通讯录查询接口停用
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static UserGetRes getUser(String addressBookToken, UserGetReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 读取成员: ");

        UserGetRes res = new UserGetRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken).replace("USERID", req.getUserId());

        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 更新成员
     */
    public static UserUpdateRes updateUser(String addressBookToken, UserUpdateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 更新成员: ");

        req.setBody(req.toBody());
        UserUpdateRes res = new UserUpdateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 删除成员
     */
    public static UserDeleteRes deleteUser(String addressBookToken, UserDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 删除成员: ");

        UserDeleteRes res = new UserDeleteRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("USERID", StringUtil.isBlank(req.getUserid()) ? "" : req.getUserid());

        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 批量删除成员
     */
    public static UserBatchDeleteRes batchDeleteUser(String addressBookToken, UserBatchDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 批量删除成员: ");

        req.setBody(req.toBody());
        UserBatchDeleteRes res = new UserBatchDeleteRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 获取部门成员<br/>
     * 注：已停用
     */
    public static <AddressBookToken extends AccessToken> void simpleListByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    /**
     * 获取部门成员详情<br/>
     * * 注：已停用
     */
    public static <AddressBookToken extends AccessToken> void listByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    /**
     * userid转openid
     */
    public static UserConvertToOpenidRes convertToOpenid(String addressBookToken, UserConvertToOpenidReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 userid转openid: ");

        req.setBody(req.toBody());
        UserConvertToOpenidRes res = new UserConvertToOpenidRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * openid转userid
     */
    public static UserConvertToUseridRes convertToUserid(String addressBookToken, UserConvertToUseridReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 openid转userid: ");

        req.setBody(req.toBody());
        UserConvertToUseridRes res = new UserConvertToUseridRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 二次验证
     */
    public static UserAuthSuccRes authSucc(String addressBookToken, UserAuthSuccReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 登录二次验证: ");

        UserAuthSuccRes res = new UserAuthSuccRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/authsucc?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("USERID", StringUtil.isBlank(req.getUserid()) ? "" : req.getUserid());

        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 邀请成员<br/>
     * 企业可通过接口批量邀请成员使用企业微信，邀请后将通过短信或邮件下发通知。
     */
    public static <AddressBookToken extends AccessToken> void batchInvite() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/invite?access_token=ACCESS_TOKEN";
        // todo 邀请成员
    }

    /**
     * 获取加入企业二维码<br/>
     * 支持企业用户获取实时成员加入二维码。
     */
    public static <AddressBookToken extends AccessToken> void getJoinQrcode() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/corp/get_join_qrcode?access_token=ACCESS_TOKEN&size_type=SIZE_TYPE";
        // todo 获取加入企业二维码
    }


    /**
     * 手机号获取userid<br/>
     * 通过手机号获取其所对应的userid。 <br/>
     * 注：请确保手机号的正确性，若出错的次数超出企业规模人数的20%，会导致1天不可调用。
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static UserGetIdByMobileRes getUseridByMobile(String addressBookToken, UserGetIdByMobileReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 手机号获取userid: ");

        req.setBody(req.toBody());
        UserGetIdByMobileRes res = new UserGetIdByMobileRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 邮箱获取userid <br/>
     * 通过邮箱获取其所对应的userid。 <br/>
     * 注：请确保邮箱的正确性，若出错的次数较多，会导致1天不可调用。（限制阈值取决于安装企业的员工规模）
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static UserGetIdByEmailRes getUseridByEmail(String addressBookToken, UserGetIdByEmailReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 邮箱获取userid: ");

        req.setBody(req.toBody());
        UserGetIdByEmailRes res = new UserGetIdByEmailRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get_userid_by_email?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 获取成员ID列表<br/>
     * 获取企业成员的userid与对应的部门ID列表<br/>
     * 注：仅支持通过“通讯录同步secret”调用。<br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static UserListIdRes listId(String addressBookToken, UserListIdReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 获取成员ID列表: ");

        req.setBody(req.toBody());
        UserListIdRes res = new UserListIdRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list_id?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }
}
