package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.user.pojo;

import cn.net.wanmo.common.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class User implements Serializable {

    /**
     * 是	成员UserID。对应管理端的账号，企业内必须唯一。长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。系统进行唯一性检查时会忽略大小写。
     */
    private String userid;
    /**
     * 是	成员名称。长度为1~64个utf8字符
     */
    private String name;
    /**
     * 否	成员别名。长度1~64个utf8字符
     */
    private String alias;

    /**
     * 否	性别。1表示男性，2表示女性
     */
    private Gender gender = Gender.unknown;
    /**
     * 否	成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
     */
    private String avatarMediaid;
    /**
     * 否	地址。长度最大128个字符
     */
    private String address;
    /**
     * 否	座机。32字节以内，由纯数字、“-”、“+”或“,”组成。
     */
    private String telephone;
    /**
     * 否	手机号码。企业内必须唯一，mobile/email二者不能同时为空
     */
    private String mobile;
    /**
     * 否	邮箱。长度6~64个字节，且为有效的email格式。企业内必须唯一，mobile/email二者不能同时为空
     */
    private String email;
    /**
     * 否	企业邮箱。仅对开通企业邮箱的企业有效。长度6~64个字节，且为有效的企业邮箱格式。企业内必须唯一。未填写则系统会为用户生成默认企业邮箱（由系统生成的邮箱可修改一次）
     */
    private String bizMail;
    /**
     * 否	是否邀请该成员使用企业微信（将通过微信服务通知或短信或邮件下发邀请，每天自动下发一次，最多持续3个工作日），默认值为true。
     */
    private boolean toInvite;
    /**
     * 否	职务信息。长度为0~128个字符
     */
    private String position;
    /**
     * 否	个数必须和参数department的个数一致，表示在所在的部门内是否为部门负责人。1表示为部门负责人，0表示非部门负责人。在审批(自建、第三方)等应用里可以用来标识上级审批人
     */
    private List<IsLeaderInDept> isLeaderInDepts = new ArrayList<>();
    /**
     * 否	直属上级UserID，设置范围为企业内成员，可以设置最多1个上级
     */
    private List<String> directLeaders = new ArrayList<>();
    /**
     * 否	主部门
     */
    private Integer mainDepartmentId;
    /**
     * 否	成员所属部门id列表，不超过100个。当不填写department或id为0时，成员会放在其他（待设置部门）下，当填写的部门不存在时，会在在其他（待设置部门）下新建对应部门
     */
    private List<Integer> departmentIds = new ArrayList<>();
    /**
     * 否	部门内的排序值，默认为0，成员次序以创建时间从小到大排列。个数必须和参数department的个数一致，数值越大排序越前面。有效的值范围是[0, 2^32)
     */
    private List<Integer> order;
    /**
     * 否	启用/禁用成员。1表示启用成员，0表示禁用成员
     */
    private Enable enable = Enable.unknown;
    /**
     * 否	自定义字段。自定义字段需要先在WEB管理端添加，见扩展属性添加方法，否则忽略未知属性的赋值。
     */
    private ExtProfile extProfile = new ExtProfile();
    /**
     * 否	对外职务，如果设置了该值，则以此作为对外展示的职务，否则以position来展示。长度12个汉字内
     */
    private String externalPosition;
    /**
     * 否	成员对外属性，字段详情见对外属性
     */
    private ExternalProfile externalProfile = new ExternalProfile();


    public User() {
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getAvatarMediaid() {
        return avatarMediaid;
    }

    public void setAvatarMediaid(String avatarMediaid) {
        this.avatarMediaid = avatarMediaid;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBizMail() {
        return bizMail;
    }

    public void setBizMail(String bizMail) {
        this.bizMail = bizMail;
    }

    public boolean isToInvite() {
        return toInvite;
    }

    public void setToInvite(boolean toInvite) {
        this.toInvite = toInvite;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public List<IsLeaderInDept> getIsLeaderInDepts() {
        return isLeaderInDepts;
    }

    public void setIsLeaderInDepts(List<IsLeaderInDept> isLeaderInDepts) {
        this.isLeaderInDepts = isLeaderInDepts;
    }

    public List<String> getDirectLeaders() {
        return directLeaders;
    }

    public void setDirectLeaders(List<String> directLeaders) {
        this.directLeaders = directLeaders;
    }

    public Integer getMainDepartmentId() {
        return mainDepartmentId;
    }

    public void setMainDepartmentId(Integer mainDepartmentId) {
        this.mainDepartmentId = mainDepartmentId;
    }

    public List<Integer> getDepartmentIds() {
        return departmentIds;
    }

    public void setDepartmentIds(List<Integer> departmentIds) {
        this.departmentIds = departmentIds;
    }

    public List<Integer> getOrder() {
        return order;
    }

    public void setOrder(List<Integer> order) {
        this.order = order;
    }

    public Enable getEnable() {
        return enable;
    }

    public void setEnable(Enable enable) {
        this.enable = enable;
    }

    public ExtProfile getExtProfile() {
        return extProfile;
    }

    public void setExtProfile(ExtProfile extProfile) {
        this.extProfile = extProfile;
    }

    public String getExternalPosition() {
        return externalPosition;
    }

    public void setExternalPosition(String externalPosition) {
        this.externalPosition = externalPosition;
    }

    public ExternalProfile getExternalProfile() {
        return externalProfile;
    }

    public void setExternalProfile(ExternalProfile externalProfile) {
        this.externalProfile = externalProfile;
    }

    /**
     * 自定义字段。自定义字段需要先在WEB管理端添加，见扩展属性添加方法，否则忽略未知属性的赋值
     */
    public static class ExtProfile {

        private List<ExtAttr> attrs = new ArrayList<>();

        public ExtProfile() {
        }

        public List<ExtAttr> getAttrs() {
            return attrs;
        }

        public void setAttrs(List<ExtAttr> attrs) {
            this.attrs = attrs;
        }

        /**
         * 自定义字段
         */
        public static class ExtAttr {
            /**
             * 是	属性类型: 0-文本 1-网页
             */
            private ExtAttrType type = ExtAttrType.unknown;
            /**
             * 是	属性名称： 需要先确保在管理端有创建该属性，否则会忽略
             */
            private String name;
            /**
             * 否	文本类型的属性
             */
            private Text text = new Text();
            /**
             * 否	网页类型的属性，url和title字段要么同时为空表示清除该属性，要么同时不为空
             */
            private Web web = new Web();


            public ExtAttr() {
            }

            public ExtAttrType getType() {
                return type;
            }

            public void setType(ExtAttrType type) {
                this.type = type;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Text getText() {
                return text;
            }

            public void setText(Text text) {
                this.text = text;
            }

            public Web getWeb() {
                return web;
            }

            public void setWeb(Web web) {
                this.web = web;
            }

            /**
             * 自定义字段 文本类型 <br/>
             * 否	文本类型的属性
             */
            public class Text {
                /**
                 * 是	文本属性内容，长度限制64个UTF8字符
                 */
                private String value;

                public Text() {
                }

                public String getValue() {
                    return value;
                }

                public void setValue(String value) {
                    this.value = value;
                }
            }


            /**
             * 自定义字段 网页类型 <br/>
             * 是 网页类型的属性，url和title字段要么同时为空表示清除该属性，要么同时不为空
             */
            public class Web {
                /**
                 * 是 网页的展示标题,长度限制12个UTF8字符
                 */
                private String title;
                /**
                 * 是 网页的url,必须包含http或者https头
                 */
                private String url;

                public Web() {
                }

                public String getTitle() {
                    return title;
                }

                public void setTitle(String title) {
                    this.title = title;
                }

                public String getUrl() {
                    return url;
                }

                public void setUrl(String url) {
                    this.url = url;
                }
            }
        }

    }


    /**
     * 成员对外属性
     */
    public static class ExternalProfile {
        /**
         * 企业简称
         */
        private String externalCorpName;
        /**
         * 视频号
         */
        private WechatChannels wechatChannels = new WechatChannels();

        /**
         * 成员对外属性
         */
        private List<ExternalAttr> externalAttrs = new ArrayList<>();

        public ExternalProfile() {
        }

        public String getExternalCorpName() {
            return externalCorpName;
        }

        public void setExternalCorpName(String externalCorpName) {
            this.externalCorpName = externalCorpName;
        }

        public WechatChannels getWechatChannels() {
            return wechatChannels;
        }

        public void setWechatChannels(WechatChannels wechatChannels) {
            this.wechatChannels = wechatChannels;
        }

        public List<ExternalAttr> getExternalAttrs() {
            return externalAttrs;
        }

        public void setExternalAttrs(List<ExternalAttr> externalAttrs) {
            this.externalAttrs = externalAttrs;
        }

        public class WechatChannels {
            /**
             * 否	视频号名字（设置后，成员将对外展示该视频号）。须从企业绑定到企业微信的视频号中选择，可在“我的企业”页中查看绑定的视频号
             */
            private String nickname;

            public WechatChannels() {
            }

            public String getNickname() {
                return nickname;
            }

            public void setNickname(String nickname) {
                this.nickname = nickname;
            }
        }

        public static class ExternalAttr {
            /**
             * 类型
             */
            private ExternalProfileExternalAttrType type = ExternalProfileExternalAttrType.unknown;
            /**
             * 名称
             */
            private String name;

            private Text text = new Text();
            private Web web = new Web();
            private Miniprogram miniprogram = new Miniprogram();

            public ExternalAttr() {
            }

            public ExternalProfileExternalAttrType getType() {
                return type;
            }

            public void setType(ExternalProfileExternalAttrType type) {
                this.type = type;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Text getText() {
                return text;
            }

            public void setText(Text text) {
                this.text = text;
            }

            public Web getWeb() {
                return web;
            }

            public void setWeb(Web web) {
                this.web = web;
            }

            public Miniprogram getMiniprogram() {
                return miniprogram;
            }

            public void setMiniprogram(Miniprogram miniprogram) {
                this.miniprogram = miniprogram;
            }

            public class Text {
                private String value;

                public Text() {
                }

                public String getValue() {
                    return value;
                }

                public void setValue(String value) {
                    this.value = value;
                }
            }

            public class Web {
                private String title;
                private String url;

                public Web() {
                }

                public String getTitle() {
                    return title;
                }

                public void setTitle(String title) {
                    this.title = title;
                }

                public String getUrl() {
                    return url;
                }

                public void setUrl(String url) {
                    this.url = url;
                }
            }

            public class Miniprogram {
                private String appid;
                private String title;
                private String pagePath;

                public Miniprogram() {
                }

                public String getAppid() {
                    return appid;
                }

                public void setAppid(String appid) {
                    this.appid = appid;
                }

                public String getTitle() {
                    return title;
                }

                public void setTitle(String title) {
                    this.title = title;
                }

                public String getPagePath() {
                    return pagePath;
                }

                public void setPagePath(String pagePath) {
                    this.pagePath = pagePath;
                }
            }

        }
    }

    /**
     * 启用
     */
    public enum Enable {
        unknown("", "未知"),
        yes("1", "启用"),
        no("0", "禁用");

        private final String value;
        private final String label;

        Enable(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static Enable changeOf(String value) {
            Enable r = Enable.unknown;

            Enable[] values = Enable.values();
            for (Enable e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }
    }


    /**
     * 性别
     */
    public enum Gender {
        unknown("", "未知"),
        male("1", "男"),
        female("2", "女");

        private final String value;
        private final String label;

        Gender(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static Gender changeOf(String value) {
            Gender r = Gender.unknown;

            Gender[] values = Gender.values();
            for (Gender e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }
    }


    /**
     * 是否部门负责人
     */
    public enum IsLeaderInDept {
        unknown("", "未知"),
        yes("1", "部门负责人"),
        no("0", "非部门负责人");

        private final String value;
        private final String label;

        IsLeaderInDept(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static IsLeaderInDept changeOf(String value) {
            IsLeaderInDept r = IsLeaderInDept.unknown;

            IsLeaderInDept[] values = IsLeaderInDept.values();
            for (IsLeaderInDept e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }
    }


    /**
     * 自定义字段 属性类型
     */
    public enum ExtAttrType {
        unknown("", "未知"),
        text("0", "文本"),
        web("1", "网页");

        private final String value;
        private final String label;

        ExtAttrType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static ExtAttrType changeOf(String value) {
            ExtAttrType r = ExtAttrType.unknown;

            ExtAttrType[] values = ExtAttrType.values();
            for (ExtAttrType e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }
    }


    /**
     * 启用
     */
    public enum ExternalProfileExternalAttrType {
        unknown("", "未知"),
        text("0", "文本"),
        web("1", "网页"),
        miniprogram("2", "小程序");

        private final String value;
        private final String label;

        ExternalProfileExternalAttrType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        /**
         * 转为 对象
         *
         * @param value 值
         * @return 对象
         */
        public static ExternalProfileExternalAttrType changeOf(String value) {
            ExternalProfileExternalAttrType r = ExternalProfileExternalAttrType.unknown;

            ExternalProfileExternalAttrType[] values = ExternalProfileExternalAttrType.values();
            for (ExternalProfileExternalAttrType e : values) {
                if (StringUtil.equals(value, e.value)) {
                    r = e;
                    break;
                }
            }

            return r;
        }
    }
}
