package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.user.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UserListIdData implements Serializable {

    /** 分页游标，下次请求时填写以获取之后分页的记录。如果该字段返回空则表示已没有更多数据 */
    private String nextCursor;
    /** 用户-部门关系列表 */
    private List<DeptUser> deptUsers = new ArrayList<>();

    public UserListIdData() {
    }

    public String getNextCursor() {
        return nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public List<DeptUser> getDeptUsers() {
        return deptUsers;
    }

    public void setDeptUsers(List<DeptUser> deptUsers) {
        this.deptUsers = deptUsers;
    }

    // ======================================================
    public DeptUser newDeptUser() {
        return new DeptUser();
    }

    /**
     * 用户-部门关系列表
     */
    public class DeptUser {
        /** 用户userid，当用户在多个部门下时会有多条记录 */
        private String userid;
        /** 用户所属部门 */
        private Integer department;

        public DeptUser() {
        }

        public String getUserid() {
            return userid;
        }

        public void setUserid(String userid) {
            this.userid = userid;
        }

        public Integer getDepartment() {
            return department;
        }

        public void setDepartment(Integer department) {
            this.department = department;
        }
    }
}
