package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.user.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

public class UserListIdRes extends WechatBaseRes<UserListIdData> {
    @Override
    protected void initData() {
        this.data = new UserListIdData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        this.data.setNextCursor(object.getString("next_cursor"));
        {
            JSONArray array = object.getJSONArray("dept_user");
            if (array == null || array.isEmpty()) {} else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject temp = array.getJSONObject(i);
                    UserListIdData.DeptUser deptUser = this.data.newDeptUser();

                    deptUser.setUserid(temp.getString("userid"));
                    deptUser.setDepartment(temp.getInteger("department"));

                    this.data.getDeptUsers().add(deptUser);
                }
            }
        }


        return super.parseObj(resBody);
    }

}
