package cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo;

import java.io.Serializable;

public class GetUserinfoData implements Serializable {

    /**
     * a) 当用户为企业成员时（无论是否在应用可见范围之内）返回示例如下：<br/>
     * <br/>
     * 成员UserID。若需要获得用户详情信息，可调用通讯录接口：读取成员。如果是互联企业/企业互联/上下游，则返回的UserId格式如：CorpId/userid
     */
    private String userId;
    /**
     * a) 当用户为企业成员时（无论是否在应用可见范围之内）返回示例如下：<br/>
     * <br/>
     * 成员票据，最大为512字节，有效期为1800s。<br/>
     * scope为 snsapi_privateinfo，且用户在应用可见范围之内时返回此参数。<br/>
     * 后续利用该参数可以获取用户信息或敏感信息，参见"获取访问用户敏感信息"。暂时不支持上下游或/企业互联场景 <br/>
     */
    private String userTicket;

    /**
     * b) 非企业成员时，返回示例如下：<br/>
     * <br/>
     * 非企业成员的标识，对当前企业唯一。不超过64字节
     */
    private String openId;
    /**
     * b) 非企业成员时，返回示例如下：<br/>
     * <br/>
     * 外部联系人id，当且仅当用户是企业的客户，且跟进人在应用的可见范围内时返回。如果是第三方应用调用，针对同一个客户，同一个服务商不同应用获取到的id相同
     */
    private String externalUserid;

    public GetUserinfoData() {
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserTicket() {
        return userTicket;
    }

    public void setUserTicket(String userTicket) {
        this.userTicket = userTicket;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getExternalUserid() {
        return externalUserid;
    }

    public void setExternalUserid(String externalUserid) {
        this.externalUserid = externalUserid;
    }
}
