package cn.net.wanmo.common.weixin.work.third.app_empower;

import cn.net.wanmo.common.http.jdk.HttpJdkUtil;
import cn.net.wanmo.common.http.jdk.pojo.ResData;
import cn.net.wanmo.common.result.HttpResult;
import cn.net.wanmo.common.weixin.work.third.util.AccessTokenUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 第三方应用开发 -> 服务端API -> 应用授权 -> 通讯录权限体系
 */
public class AddressBookUtil {
    private static Logger logger = LoggerFactory.getLogger(AddressBookUtil.class);

    /**
     * 获取 应用授权的 suite_access_token
     * 企业在授权应用时，第三方需要以suite_id（第三方应用ID）、suite_secret（第三方应用密钥）（获取方法为：登录服务商管理后台->标准应用服务->应用管理栏，点进某个应用即可看到）换取suite_access_token，再以suite_access_token访问应用授权的接口
     * <br />引用：AccessTokenUtil.getSuiteAccessToken();
     * @param suiteId
     * @param suiteSecret
     * @param suiteTicket
     * @return JSONObject (errcode, errmsg, suite_access_token, expires_in)
     */
    public static JSONObject getSuiteAccessToken(String suiteId, String suiteSecret, String suiteTicket) {
        return AccessTokenUtil.getSuiteAccessToken(suiteId, suiteSecret, suiteTicket);
    }

    /**
     * 获取预授权码。预授权码用于企业授权时的第三方服务商安全验证。
     * @param suiteAccessToken 第三方应用access_token,最长为512字节
     * @return JSONObject (errcode, errmsg, pre_auth_code, expires_in)
     */
    public static JSONObject getPreAuthCode(String suiteAccessToken) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=SUITE_ACCESS_TOKEN";
        url = url.replace("SUITE_ACCESS_TOKEN", suiteAccessToken);

        JSONObject jsonObjectRes = new JSONObject();

        HttpResult<ResData> result = HttpJdkUtil.get(url).send();
        if (result.isSuccess()) {
            String body = result.getData().getBody();
            logger.debug("获取 pre_auth_code 请求 http 成功：{}" , body);

            jsonObjectRes = JSON.parseObject(body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            String preAuthCode = jsonObjectRes.getString("pre_auth_code");
            Integer expiresIn = jsonObjectRes.getInteger("expires_in");
            if (errcode == 0) {
                logger.debug("获取 pre_auth_code 成功： {}，有效时常： {}", preAuthCode, expiresIn);
            } else {
                logger.debug("获取 pre_auth_code 失败： {}，错误码： {}", errmsg, errcode);
            }
        } else {
            jsonObjectRes.put("errcode", -1);
            jsonObjectRes.put("errmsg", result.getMsg());
            logger.error("获取 pre_auth_code 请求 http 失败：{}", result.getMsg());
        }


        return jsonObjectRes;
    }

    /**
     * 设置授权配置：该接口可对某次授权进行配置。可支持测试模式（应用未发布时）。
     * 请求包体：
     * <pre>
     * {
     * 	"pre_auth_code":"xxxxx",
     * 	"session_info":
     *        {
     * 		"appid":[1,2,3],
     * 		"auth_type":1
     *    }
     * }
     * </pre>
     *
     * @param suiteAccessToken 第三方应用access_token
     * @param preAuthCode 预授权码
     * @param suiteIds 已忽略该参数。 // 允许进行授权的应用id，如1、2、3， 不填或者填空数组都表示允许授权套件内所有应用（仅旧的多应用套件可传此参数，新开发者可忽略）
     * @param authType 授权类型：0 正式授权， 1 测试授权。 默认值为0。注意，请确保应用在正式发布后的授权类型为“正式授权”
     */
    public static JSONObject setSessionInfo(String suiteAccessToken, String preAuthCode, String[] suiteIds, int authType) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=SUITE_ACCESS_TOKEN";
        url = url.replace("SUITE_ACCESS_TOKEN", suiteAccessToken);

        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put("pre_auth_code", preAuthCode);
        JSONObject sessionInfo = new JSONObject();
        sessionInfo.put("appid", new String[]{}); // 忽略该参数
        sessionInfo.put("auth_type", authType);
        jsonObjectReq.put("session_info", sessionInfo);
        System.out.println(jsonObjectReq.toJSONString());

        HttpResult<ResData> result = HttpJdkUtil.post(url).body(jsonObjectReq.toJSONString()).send();

        JSONObject jsonObjectRes = new JSONObject();
        if (result.isSuccess()) {
            String body = result.getData().getBody();
            logger.debug("设置授权配置 请求 http 成功：{}" , body);

            jsonObjectRes = JSON.parseObject(body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            if (errcode == 0) {
                logger.debug("设置授权配置 成功 ");
            } else {
                logger.debug("设置授权配置 失败： {}，错误码： {}", errmsg, errcode);
            }
        } else {
            jsonObjectRes.put("errcode", -1);
            jsonObjectRes.put("errmsg", result.getMsg());
            logger.error("设置授权配置 请求 http 失败：{}", result.getMsg());
        }

        return jsonObjectRes;


    }
}
