package cn.net.wanmo.common.weixin.work.third.app_empower;

import cn.net.wanmo.common.codec.CodecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 第三方应用开发 -> 服务端API -> 应用授权 -> 企业授权应用
 * <br/>企业微信的系统管理员可以授权安装第三方应用，安装后企业微信后台会将授权凭证、授权信息等推送给服务商后台。
 * <br/>授权可以有两种发起方式：
 * <br/> 1. 从服务商网站发起
 * <br/> 2. 从企业微信应用市场发起
 */
public class EnterpriseAuthApp {
    private static Logger logger = LoggerFactory.getLogger(EnterpriseAuthApp.class);

    /**
     * 第三方服务商需构造授权链接，引导用户进入授权页面完成授权过程，并取得临时授权码
     * <br/>用户确认授权后，会进入回调URI(即redirect_uri)，并在URI参数中带上临时授权码、过期时间以及state参数。第三方服务商据此获得临时授权码。回调地址为：
     * <br/>redirect_uri?auth_code=xxx&expires_in=600&state=xx
     * @param suiteId 第三方服务商的应用ID
     * @param preAuthCode 预授权码
     * @param redirectUri 授权完成回调URI
     * @param state 可填a-zA-Z0-9的参数值（不超过128个字节），用于第三方自行校验session，防止跨域攻击
     * @return 授权链接
     */
    public static String buildAuthUrl(String suiteId, String preAuthCode, String redirectUri, String state) {
        redirectUri = CodecUtil.urlEncode(redirectUri);
        String url = "https://open.work.weixin.qq.com/3rdapp/install?suite_id=SUITE_ID&pre_auth_code=PRE_AUTH_CODE&redirect_uri=REDIRECT_URI&state=STATE";
        url = url.replace("SUITE_ID", suiteId).replace("PRE_AUTH_CODE", preAuthCode).replace("REDIRECT_URI", redirectUri).replace("STATE", state);
        logger.debug("第三方服务商构造授权链接: {}", url);
        return url;
    }


}
