/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.send.BaseReq;
import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.GetUserDetailReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.GetUserDetailRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.GetUserinfoReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.GetUserinfoRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.Oauth2UrlReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo.Oauth2UrlRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthUtil {
    private static Logger logger = LoggerFactory.getLogger(WebAuthUtil.class);

    public static Oauth2UrlRes buildPageOauth2Url(Oauth2UrlReq req) {
        String corpId = req.getCorpId();
        String agentId = req.getAgentId();
        String redirectUri = CodecUtil.urlEncode((String)req.getRedirectUri());
        String scope = req.getScope().getValue();
        String state = req.getState();
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=CORPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE&agentid=AGENTID#wechat_redirect";
        url = url.replace("CORPID", corpId).replace("AGENTID", agentId).replace("REDIRECT_URI", redirectUri).replace("SCOPE", scope).replace("STATE", state);
        logger.debug("\u81ea\u5efa\u5e94\u7528 \u6784\u9020\u7f51\u9875\u6388\u6743\u94fe\u63a5 url: {}", (Object)url);
        return new Oauth2UrlRes(url);
    }

    public static GetUserinfoRes getUserinfo(String token, GetUserinfoReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u7f51\u9875\u6388\u6743\u767b\u5f55 \u83b7\u53d6\u8bbf\u95ee\u7528\u6237\u8eab\u4efd: ");
        req.setBody(null);
        GetUserinfoRes res = new GetUserinfoRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=ACCESS_TOKEN&code=CODE";
        url = url.replace("ACCESS_TOKEN", token).replace("CODE", req.getCode());
        return (GetUserinfoRes)SendUtil.get((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static GetUserDetailRes getUserDetail(String token, GetUserDetailReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u7f51\u9875\u6388\u6743\u767b\u5f55 \u83b7\u53d6\u8bbf\u95ee\u7528\u6237\u654f\u611f\u4fe1\u606f: ");
        req.setBody(req.toBody());
        GetUserDetailRes res = new GetUserDetailRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return (GetUserDetailRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }
}

