package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.department;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.address_book.department.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 需配置IP白名单：
 * 应用管理：企业可信IP;
 * 安全管理：通讯录同步 -> 企业可信IP;
 */
public class DepartmentUtil {
    private static Logger logger = LoggerFactory.getLogger(DepartmentUtil.class);

    /**
     * 创建部门<br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static DeptCreateRes createDept(String addressBookToken, DeptCreateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 创建部门: ");

        req.setBody(req.toBody());
        DeptCreateRes res = new DeptCreateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 更新部门<br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static DeptUpdateRes updateDept(String addressBookToken, DeptUpdateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 更新部门: ");

        req.setBody(req.toBody());
        DeptUpdateRes res = new DeptUpdateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 删除部门<br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static DeptDeleteRes deleteDept(String addressBookToken, DeptDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 删除部门: ");

        DeptDeleteRes res = new DeptDeleteRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=ACCESS_TOKEN&id=ID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("ID", req.getId());

        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 获取子部门ID列表<br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    public static DeptSimpleListRes simpleList(String addressBookToken, DeptSimpleListReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 获取子部门ID列表: ");

        DeptSimpleListRes res = new DeptSimpleListRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/simplelist?access_token=ACCESS_TOKEN&id=ID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("ID", StringUtil.isBlank(req.getId()) ? "" : req.getId());

        return SendUtil.get(msgPre, url, req, res, null);

    }

}
