package cn.net.wanmo.common.weixin.work.inner.server_api.address_book.tag.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

/**
 * 获取标签列表
 */
public class TagListRes extends WechatBaseRes<TagListData> {
    @Override
    protected void initData() {
        this.data = new TagListData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        { // 标签列表
            JSONArray array = object.getJSONArray("taglist");
            if (array == null || array.isEmpty()) {
            } else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject temp = array.getJSONObject(i);

                    TagListData.Tag tag = this.data.newTag();
                    tag.setTagId(temp.getInteger("tagid"));
                    tag.setUserName(temp.getString("tagname"));

                    this.data.getTagList().add(tag);
                }
            }
        }

        return super.parseObj(resBody);
    }

}
