package cn.net.wanmo.common.weixin.work.inner.server_api.authentication.web_auth.pojo;

import cn.net.wanmo.common.util.StringUtil;

import java.io.Serializable;

public class GetUserDetailData implements Serializable {

    /** 成员UserID */
    private String userId;
    /** 性别。0表示未定义，1表示男性，2表示女性。仅在用户同意snsapi_privateinfo授权时返回真实值，否则返回0. */
    private Gender gender;
    /** 头像url。仅在用户同意snsapi_privateinfo授权时返回真实头像，否则返回默认头像 */
    private String avatar;
    /** 员工个人二维码（扫描可添加为外部联系人），仅在用户同意snsapi_privateinfo授权时返回 */
    private String qrCode;
    /** 手机，仅在用户同意snsapi_privateinfo授权时返回，第三方应用不可获取 */
    private String mobile;
    /** 邮箱，仅在用户同意snsapi_privateinfo授权时返回，第三方应用不可获取 */
    private String email;
    /** 企业邮箱，仅在用户同意snsapi_privateinfo授权时返回，第三方应用不可获取 */
    private String bizMail;
    /** 仅在用户同意snsapi_privateinfo授权时返回，第三方应用不可获取 */
    private String address;

    public GetUserDetailData() {
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBizMail() {
        return bizMail;
    }

    public void setBizMail(String bizMail) {
        this.bizMail = bizMail;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Gender convertOf(String value) {
        return Gender.convertOf(value);
    }

    public enum Gender {
        unknown("0", "未定义"),
        male("1", "男"),
        female("2", "女");

        private final String value;
        private final String label;

        Gender(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public static Gender convertOf(String value) {
            Gender r = Gender.unknown;

            for (Gender type : values()) {
                if (StringUtil.equals(value, type.getValue())) {
                    r = type;
                    break;
                }
            }

            return r;
        }
    }
}
