package cn.net.wanmo.common.weixin.work.inner.server_api.server_ip;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.CommonUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.server_ip.pojo.ApiDomainIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.server_ip.pojo.ApiDomainIpRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.server_ip.pojo.CallbackIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.server_ip.pojo.CallbackIpRes;

public class ServerIpUtil {


    /**
     * 获取企业微信接口IP段
     * <pre>
     *     API域名IP即qyapi.weixin.qq.com的解析地址，由开发者调用企业微信端的接入IP。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     *
     * @param agentToken 应用令牌
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.ApiDomainIp
     * </pre>
     */
    public static ApiDomainIpRes getApiDomainIp(String agentToken) {
        String msgPre = CommonUtil.getInterfaceTitle("获取企业微信接口IP段: ");

        ApiDomainIpReq req = new ApiDomainIpReq();
        ApiDomainIpRes res = new ApiDomainIpRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_api_domain_ip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 获取企业微信回调IP段
     * <pre>
     *     企业微信在回调企业指定的URL时，是通过特定的IP发送出去的。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     *
     * @param agentToken 应用令牌
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.CallbackIp
     * </pre>
     */
    public static CallbackIpRes getCallbackIp(String agentToken) {
        String msgPre = CommonUtil.getInterfaceTitle("获取企业微信回调IP段: ");

        CallbackIpReq req = new CallbackIpReq();
        CallbackIpRes res = new CallbackIpRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", agentToken);

        return SendUtil.get(msgPre, url, req, res, null);
    }

}
