/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.access_token.storage;

import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.pojo.log.TokenLog;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.TicketToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.AccessTokenUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.pojo.AccessTokenData;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.pojo.AccessTokenReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.access_token.util.pojo.AccessTokenRes;
import cn.net.wanmo.common.weixin.work.pojo.Token;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenForAgent {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenForAgent.class);
    private static Map<String, Agent> agentMap = new HashMap<String, Agent>();

    private static String getMapKey(String corpId, String agentId) {
        return corpId + ":" + agentId;
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> void putAgent(String corpId, String agentId, Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent) {
        ((Token)agent.getAgentToken()).storeToken();
        agentMap.put(AccessTokenForAgent.getMapKey(corpId, agentId), agent);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> Agent<AgentToken, JsApiTicket, JsApiConfigTicket> getAgent(String corpId, String agentId) {
        return agentMap.getOrDefault(AccessTokenForAgent.getMapKey(corpId, agentId), new Agent());
    }

    public static AccessTokenRes initTokenForAgent(Agent agent) {
        return AccessTokenForAgent.initTokenForAgent(agent, null);
    }

    public static <AgentToken extends AccessToken> AccessTokenRes initTokenForAgent(Agent agent, AgentToken agentToken) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentSecret = agent.getSecret();
        return AccessTokenForAgent.initTokenForAgent(corpId, agentId, agentSecret, agentToken);
    }

    public static AccessTokenRes initTokenForAgent(String corpId, String agentId, String agentSecret) {
        return AccessTokenForAgent.initTokenForAgent(corpId, agentId, agentSecret, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> AccessTokenRes initTokenForAgent(String corpId, String agentId, String agentSecret, AgentToken agentToken) {
        Agent<AccessToken, JsApiTicket, JsApiConfigTicket> agent;
        AccessTokenReq req = AccessTokenReq.build(corpId, agentSecret);
        AccessTokenRes result = AccessTokenUtil.getAccessToken(req);
        AccessToken accessToken = new AccessToken();
        accessToken.setCorpId(corpId);
        accessToken.setAgentId(agentId);
        accessToken.setTokenType(AccessToken.TokenType.access_agent);
        accessToken.setCode(String.valueOf(result.getErrCode()));
        accessToken.setMsg(result.getErrMsg());
        accessToken.setResTime(result.getResTime());
        if (result.isSuccess()) {
            AccessTokenData data = (AccessTokenData)result.getData();
            accessToken.setValue(data.getToken());
            accessToken.setExpiresIn(data.getExpiresIn());
        }
        if (Objects.isNull(agentToken)) {
            agent = AccessTokenForAgent.getAgent(corpId, agentId);
            agent.setAgentToken(accessToken);
            AccessTokenForAgent.putAgent(corpId, agentId, agent);
            logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5e94\u7528ID: {}, \u6267\u884c\u9ed8\u8ba4\u5b58\u50a8\u5e94\u7528\u4ee4\u724c\u5b8c\u6210 ...", (Object)corpId, (Object)agentId);
        } else {
            agentToken.setCorpId(corpId);
            agentToken.setAgentId(agentId);
            agentToken.setTokenType(accessToken.getTokenType());
            agentToken.setCode(accessToken.getCode());
            agentToken.setMsg(accessToken.getMsg());
            agentToken.setValue(accessToken.getValue());
            agentToken.setExpiresIn(accessToken.getExpiresIn());
            agentToken.setResTime(accessToken.getResTime());
            agent = AccessTokenForAgent.getAgent(corpId, agentId);
            agent.setAgentToken(agentToken);
            AccessTokenForAgent.putAgent(corpId, agentId, agent);
            logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5e94\u7528ID: {}, \u6267\u884c\u81ea\u5b9a\u4e49\u5b58\u50a8\u5e94\u7528\u4ee4\u724c\u5b8c\u6210 ...", (Object)corpId, (Object)agentId);
        }
        TokenLog.put(corpId, agentId, accessToken.getTokenType().getLabel(), accessToken, TokenLog.agentTokenMap);
        return result;
    }

    public static void runThreadInitTokenForAgent(Agent agent) {
        AccessTokenForAgent.runThreadInitTokenForAgent(agent, null, null, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitTokenForAgent(Agent agent, AgentToken agentToken) {
        AccessTokenForAgent.runThreadInitTokenForAgent(agent, null, null, agentToken);
    }

    public static void runThreadInitTokenForAgent(Agent agent, Integer residueSecond, Integer waitSecond) {
        AccessTokenForAgent.runThreadInitTokenForAgent(agent, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitTokenForAgent(Agent agent, Integer residueSecond, Integer waitSecond, AgentToken agentToken) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentSecret = agent.getSecret();
        AccessTokenForAgent.runThreadInitTokenForAgent(corpId, agentId, agentSecret, residueSecond, waitSecond, agentToken);
    }

    public static void runThreadInitTokenForAgent(String corpId, String agentId, String agentSecret) {
        AccessTokenForAgent.runThreadInitTokenForAgent(corpId, agentId, agentSecret, null, null, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitTokenForAgent(String corpId, String agentId, String agentSecret, AgentToken agentToken) {
        AccessTokenForAgent.runThreadInitTokenForAgent(corpId, agentId, agentSecret, null, null, agentToken);
    }

    public static void runThreadInitTokenForAgent(String corpId, String agentId, String agentSecret, Integer residueSecond, Integer waitSecond) {
        AccessTokenForAgent.runThreadInitTokenForAgent(corpId, agentId, agentSecret, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitTokenForAgent(final String corpId, final String agentId, final String agentSecret, final Integer residueSecond, final Integer waitSecond, final AgentToken agentToken) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            AccessTokenRes result;
                            if ((result = AccessTokenForAgent.initTokenForAgent(corpId, agentId, agentSecret, agentToken)).isSuccess()) {
                                String token = ((AccessTokenData)result.getData()).getToken();
                                Integer expiresIn = ((AccessTokenData)result.getData()).getExpiresIn();
                                logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c token = {}", new Object[]{corpId, agentId, expiresIn, token});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{corpId, agentId, result.getErrCode(), result.getErrMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4f01\u4e1a\u5fae\u4fe1ID: " + corpId + ", \u5e94\u7528ID: " + agentId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }, "wechat-work-agent-access_token-" + corpId + "-" + agentId).start();
    }
}

