/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo;

import cn.net.wanmo.common.weixin.work.inner.server_api.message.pojo.MessageReq;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class NewsMessageReq
extends MessageReq {
    private News news;

    public static NewsMessageReq build(String agentId) {
        NewsMessageReq req = new NewsMessageReq();
        req.setAgentId(agentId);
        return req;
    }

    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("touser", (Object)this.getToUser());
        params.put("toparty", (Object)this.getToParty());
        params.put("totag", (Object)this.getToTag());
        params.put("msgtype", (Object)this.getMsgType().getValue());
        params.put("agentid", (Object)this.getAgentId());
        params.put("news", (Object)this.getNews());
        params.put("enable_id_trans", (Object)this.getEnableIdTrans());
        params.put("enable_duplicate_check", (Object)this.getEnableDuplicateCheck());
        params.put("duplicate_check_interval", (Object)this.getDuplicateCheckInterval());
        return params.toJSONString();
    }

    public NewsMessageReq() {
        this.msgType = MessageReq.MsgType.news;
        this.news = new News();
    }

    public News getNews() {
        return this.news;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public Article newArticle() {
        return new Article();
    }

    public Article addArticle(String title, String description, String url, String picUrl) {
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        article.setUrl(url);
        article.setPicUrl(picUrl);
        this.getNews().addArticle(article);
        return article;
    }

    public Article addArticle(String title, String description, String picUrl, String appid, String pagePath) {
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        article.setPicUrl(picUrl);
        article.setAppId(appid);
        article.setPagePath(pagePath);
        this.getNews().addArticle(article);
        return article;
    }

    public class Article
    extends JSONObject {
        private String title = "title";
        private String description = "description";
        private String url = "url";
        private String picUrl = "picurl";
        private String appId = "appid";
        private String pagePath = "pagepath";

        public String getTitle() {
            return this.getString(this.title);
        }

        public void setTitle(String title) {
            this.put(this.title, title);
        }

        public String getDescription() {
            return this.getString(this.description);
        }

        public void setDescription(String description) {
            this.put(this.description, description);
        }

        public String getUrl() {
            return this.getString(this.url);
        }

        public void setUrl(String url) {
            this.put(this.url, url);
        }

        public String getPicUrl() {
            return this.getString(this.picUrl);
        }

        public void setPicUrl(String picUrl) {
            this.put(this.picUrl, picUrl);
        }

        public String getAppId() {
            return this.getString(this.appId);
        }

        public void setAppId(String appId) {
            this.put(this.appId, appId);
        }

        public String getPagePath() {
            return this.getString(this.pagePath);
        }

        public void setPagePath(String pagePath) {
            this.put(this.pagePath, pagePath);
        }
    }

    public class News
    extends JSONObject {
        private String articles = "articles";

        public News() {
            ArrayList list = new ArrayList();
            this.put(this.articles, list);
        }

        public List<Article> getArticles() {
            return (List)this.getObject(this.articles, List.class);
        }

        public void setArticles(List<Article> articles) {
            this.put(this.articles, articles);
        }

        public void addArticle(Article article) {
            List<Article> articles = this.getArticles();
            articles.add(article);
            this.put(this.articles, articles);
        }
    }
}

