package cn.net.wanmo.plugin.wechat.work.inner;

import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.Agent;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.Corp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 用来封装自建应用配置信息
 */
public class InnerConfig implements Serializable {
    /**
     * 自建应用的企业信息
     */
    private Corp corp = new Corp<>();
    /**
     * 多个自建应用信息
     */
    private List<Agent> agents = new ArrayList<>();


    public InnerConfig() {
    }

    public Corp getCorp() {
        return corp;
    }

    public void setCorp(Corp corp) {
        this.corp = corp;
    }

    public List<Agent> getAgents() {
        return agents;
    }

    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    // =====================================================================

    /**
     * 获取应用
     *
     * @param agentId 应用ID
     * @return 应用
     */
    public Agent getAgent(String agentId) {
        Agent r = null;
        if (CollectionUtil.isEmpty(agents)) {
            return r;
        }

        for (Agent agent : agents) {
            if (StringUtil.equals(agentId, agent.getAgentId())) {
                r = agent;
                break;
            }
        }

        return r;
    }

    /**
     * 获取企业ID
     *
     * @return 企业ID
     */
    public String getCorpId() {
        return this.corp == null ? "" : this.corp.getCorpId();
    }

    /**
     * 获取企业名称
     *
     * @return 企业名称
     */
    public String getCorpTitle() {
        return this.corp == null ? "" : this.corp.getTitle();
    }
}
