package cn.net.wanmo.plugin.wechat.work.inner.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.send.BodyType;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;

/**
 * 调用企业微信官方接口，统一处理响应的数据结果
 */
public abstract class WechatBaseRes<Data> extends BaseRes<Integer, Data> {

    public WechatBaseRes() {
        super();
        this.bodyType = BodyType.obj;
    }

    public WechatBaseRes(Integer errCode, String errMsg) {
        super(errCode, errMsg);
    }

    @Override
    public BaseRes parseCodeMsg(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);
        this.errCode = object.getIntValue("errcode");
        this.errMsg = object.getString("errmsg");
        return this;
    }

    @Override
    public Integer successDataCode() {
        return 0;
    }

    @Override
    public boolean isSuccessData() {
        return successDataCode().intValue() == getErrCode().intValue();
    }

    @Override
    public String toJSONString() {
        return JSON.toJSONString(this);
    }

}
