package cn.net.wanmo.plugin.wechat.work.inner.server_api.access_token.util.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONObject;

/**
 * 访问令牌
 * <pre>
 * access_token的有效期通过返回的expires_in来传达，正常情况下为7200秒（2小时），有效期内重复获取返回相同结果，过期后获取会返回新的access_token。
 * 由于企业微信每个应用的access_token是彼此独立的，所以进行缓存时需要区分应用来进行存储。
 * access_token至少保留512字节的存储空间。
 * 企业微信可能会出于运营需要，提前使access_token失效，开发者应实现access_token失效时重新获取的逻辑。
 * </prd>
 *
 * 令牌获取机制
 * <pre>
 *     获取令牌的任务线程中，
 * </pre>
 */
public class AccessTokenRes extends WechatBaseRes<AccessTokenData> {
    @Override
    protected void initData() {
        this.data = new AccessTokenData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);


        this.data.setToken(object.getString("access_token"));
        this.data.setExpiresIn(object.getInteger("expires_in"));

        return super.parseObj(resBody);
    }

}
