package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.tag.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.Arrays;

/**
 * 删除标签成员
 */
public class TagDelUsersRes extends WechatBaseRes<TagDelUsersData> {
    @Override
    protected void initData() {
        this.data = new TagDelUsersData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        {
            String invalidlist = object.getString("invalidlist");
            if (StringUtil.isNotBlank(invalidlist)) {
                String[] split = invalidlist.split("\\|");
                this.data.setInvalidList(Arrays.asList(split));
            }
        }
        {
            JSONArray array = object.getJSONArray("invalidparty");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    Integer partyId = array.getInteger(i);
                    this.data.getInvalidParty().add(partyId);
                }
            }
        }

        return super.parseObj(resBody);
    }

}
