package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class UserBatchDeleteReq extends BaseReq {
    public static UserBatchDeleteReq build(List<String> userIds) {
        UserBatchDeleteReq req = new UserBatchDeleteReq();
        req.setUserIds(userIds);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        {
            JSONArray array = new JSONArray();
            for (String userId : userIds) {
                array.add(userId);
            }
            params.put("useridlist", userIds);
        }
        return params.toJSONString();
    }

    /**
     * 是	成员UserID列表。对应管理端的账号。最多支持200个。若存在无效UserID，直接返回错误
     */
    private List<String> userIds = new ArrayList<>();

    public UserBatchDeleteReq() {
    }

    public List<String> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }
}
