package cn.net.wanmo.plugin.wechat.work.inner.server_api.material;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.work.inner.CommonUtil;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.material.pojo.UploadTemporaryReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.material.pojo.UploadTemporaryRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 在使用企业微信API接口中，往往开发者需要使用自定义的资源，比如发送本地图片消息，设置通讯录自定义头像等。<br/>
 * 为了实现同一资源文件，一次上传可以多次使用，这里提供了素材管理接口：以media_id来标识资源文件，实现文件的上传与下载。
 *
 * <pre>
 * <b>上传的媒体文件限制</b>
 * 所有文件size必须大于5个字节
 *
 * 图片（image）：10MB，支持JPG,PNG格式
 * 语音（voice） ：2MB，播放长度不超过60s，仅支持AMR格式
 * 视频（video） ：10MB，支持MP4格式
 * 普通文件（file）：20MB
 * </pre>
 */
public class MaterialUtil {
    private static Logger logger = LoggerFactory.getLogger(MaterialUtil.class);

    /**
     * 上传临时素材
     * 素材上传得到media_id，该media_id仅三天内有效
     * media_id在同一企业内应用之间可以共享
     *
     * @param agentToken 应用令牌
     * @param req        请全体
     */
    public static UploadTemporaryRes uploadTemporary(String agentToken, UploadTemporaryReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("上传临时素材: ");

        req = UploadTemporaryReq.build(req.getType(), req.getFilename(), req.getUploadFile());
        UploadTemporaryRes res = new UploadTemporaryRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";
        url = url.replace("ACCESS_TOKEN", agentToken).replace("TYPE", req.getType().getValue());

        return SendUtil.upload(msgPre, url, req, res, null);
    }
}
