package cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo;

import com.alibaba.fastjson.JSONObject;

/**
 * markdown消息 // TODO markdown消息待实现
 */
public class MarkdownMessageReq extends MessageReq {

    public static MarkdownMessageReq build(String agentId, String content) {
        MarkdownMessageReq req = new MarkdownMessageReq();
        req.setAgentId(agentId);
        req.getMarkdown().setContent(content);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("touser", getToUser());
        params.put("toparty", getToParty());
        params.put("totag", getToTag());
        params.put("msgtype", getMsgType().getValue());
        params.put("agentid", getAgentId());
        params.put("markdown", getMarkdown().toJSONObject());
        params.put("enable_duplicate_check", getEnableDuplicateCheck());
        params.put("duplicate_check_interval", getDuplicateCheckInterval());
        return params.toJSONString();
    }

    /** 消息内容 */
    private Markdown markdown;

    public MarkdownMessageReq() {
        this.msgType = MsgType.markdown;
        this.markdown = new Markdown();
    }

    public Markdown getMarkdown() {
        return markdown;
    }

    public void setMarkdown(Markdown markdown) {
        this.markdown = markdown;
    }

    public Markdown newMarkdown() {
        return new Markdown();
    }

    public class Markdown {

        /** 消息内容，最长不超过2048个字节，超过将截断（支持id转译） */
        private String content;

        public Markdown() {
        }

        public Markdown(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }


        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("content", getContent());
            return object;
        }
    }
}
