package cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo;

import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 图文消息
 */
public class NewsMessageReq extends MessageReq {

    public static NewsMessageReq build(String agentId) {
        NewsMessageReq req = new NewsMessageReq();
        req.setAgentId(agentId);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("touser", getToUser());
        params.put("toparty", getToParty());
        params.put("totag", getToTag());
        params.put("msgtype", getMsgType().getValue());
        params.put("agentid", getAgentId());
        params.put("news", getNews());
        params.put("enable_id_trans", getEnableIdTrans());
        params.put("enable_duplicate_check", getEnableDuplicateCheck());
        params.put("duplicate_check_interval", getDuplicateCheckInterval());
        return params.toJSONString();
    }

    /** 消息内容 */
    private News news;

    public NewsMessageReq() {
        this.msgType = MsgType.news;
        this.news = new News();
    }

    public News getNews() {
        return news;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public class News extends JSONObject {
        /** 图文消息，一个图文消息支持1到8条图文 */
        private String articles = "articles";

        public News() {
            List<Article> list = new ArrayList<>();
            put(this.articles, list);
        }

        public List<Article> getArticles() {
            return getObject(this.articles, List.class);
        }

        public void setArticles(List<Article> articles) {
            put(this.articles, articles);
        }

        public void addArticle(Article article) {
            List<Article> articles = getArticles();
            articles.add(article);
            put(this.articles, articles);
        }
    }

    public class Article extends JSONObject {

        /** 标题，不超过128个字节，超过会自动截断（支持id转译） */
        private String title = "title";
        /** 描述，不超过512个字节，超过会自动截断（支持id转译） */
        private String description = "description";
        /** 点击后跳转的链接。 最长2048字节，请确保包含了协议头(http/https)，小程序或者url必须填写一个 */
        private String url = "url";
        /** 图文消息的图片链接，最长2048字节，支持JPG、PNG格式，较好的效果为大图 1068*455，小图150*150。 */
        private String picUrl = "picurl";
        /** 小程序appid，必须是与当前应用关联的小程序，appid和pagepath必须同时填写，填写后会忽略url字段 */
        private String appId = "appid";
        /** 点击消息卡片后的小程序页面，最长128字节，仅限本小程序内的页面。appid和pagepath必须同时填写，填写后会忽略url字段 */
        private String pagePath = "pagepath";

        public Article() {
        }

        public String getTitle() {
            return getString(this.title);
        }

        public void setTitle(String title) {
            put(this.title, title);
        }

        public String getDescription() {
            return getString(this.description);
        }

        public void setDescription(String description) {
            put(this.description, description);
        }

        public String getUrl() {
            return getString(this.url);
        }

        public void setUrl(String url) {
            put(this.url, url);
        }

        public String getPicUrl() {
            return getString(this.picUrl);
        }

        public void setPicUrl(String picUrl) {
            put(this.picUrl, picUrl);
        }

        public String getAppId() {
            return getString(this.appId);
        }

        public void setAppId(String appId) {
            put(this.appId, appId);
        }

        public String getPagePath() {
            return getString(this.pagePath);
        }

        public void setPagePath(String pagePath) {
            put(this.pagePath, pagePath);
        }
    }

    public Article newArticle() {
        return new Article();
    }

    public Article addArticle(String title, String description, String url, String picUrl) {
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        article.setUrl(url);
        article.setPicUrl(picUrl);

        getNews().addArticle(article);
        return article;
    }

    public Article addArticle(String title, String description, String picUrl, String appid, String pagePath) {
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        article.setPicUrl(picUrl);
        article.setAppId(appid);
        article.setPagePath(pagePath);

        getNews().addArticle(article);
        return article;
    }
}
