package cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo;

import com.alibaba.fastjson.JSONObject;

/**
 * 文本卡片消息
 */
public class TextcardMessageReq extends MessageReq {

    public static TextcardMessageReq build(String agentId) {
        TextcardMessageReq req = new TextcardMessageReq();
        req.setAgentId(agentId);
        return req;
    }

    public static TextcardMessageReq build(String agentId, String title, String description, String url, String btnTxt) {
        TextcardMessageReq req = new TextcardMessageReq();
        req.setAgentId(agentId);

        {
            Textcard textcard = req.getTextcard();
            textcard.setTitle(title);
            textcard.setDescription(description);
            textcard.setUrl(url);
            textcard.setBtnTxt(btnTxt);
            req.setTextcard(textcard);
        }
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("touser", getToUser());
        params.put("toparty", getToParty());
        params.put("totag", getToTag());
        params.put("msgtype", getMsgType().getValue());
        params.put("agentid", getAgentId());

        params.put("textcard", getTextcard().toJSONObject());

        params.put("enable_id_trans", getEnableIdTrans());
        params.put("enable_duplicate_check", getEnableDuplicateCheck());
        params.put("duplicate_check_interval", getDuplicateCheckInterval());
        return params.toJSONString();
    }

    /** 消息内容 */
    private Textcard textcard;

    public TextcardMessageReq() {
        this.msgType = MsgType.textcard;
        this.textcard = new Textcard();
    }

    public Textcard getTextcard() {
        return textcard;
    }

    public void setTextcard(Textcard textcard) {
        this.textcard = textcard;
    }

    public Textcard newTextcard() {
        return new Textcard();
    }

    public class Textcard {
        /** 标题，不超过128个字节，超过会自动截断（支持id转译） */
        private String title;
        /** 描述，不超过512个字节，超过会自动截断（支持id转译） */
        private String description;
        /** 点击后跳转的链接。最长2048字节，请确保包含了协议头(http/https) */
        private String url;
        /** 按钮文字。 默认为“详情”， 不超过4个文字，超过自动截断。 */
        private String btnTxt;

        public Textcard() {
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getBtnTxt() {
            return btnTxt;
        }

        public void setBtnTxt(String btnTxt) {
            this.btnTxt = btnTxt;
        }

        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("title", getTitle());
            object.put("description", getDescription());
            object.put("url", getUrl());
            object.put("btntxt", getBtnTxt());
            return object;
        }
    }
}
