package cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo;

import cn.net.wanmo.common.send.BaseReq;

public abstract class WebhookMessageReq extends BaseReq {
    /**
     * 消息类型
     */
    protected MsgType msgType;

    public WebhookMessageReq() {
    }

    public MsgType getMsgType() {
        return msgType;
    }

    public void setMsgType(MsgType msgType) {
        this.msgType = msgType;
    }

    public enum MsgType {
        text("文本类型"),
        image("图片类型"),
        news("图文消息"),
        voice("语音类型"),
        file("文件类型"),
        markdown("markdown类型"),
        template_card("模板卡片类型");

        private final String label;

        MsgType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }
}
