package cn.net.wanmo.plugin.wechat.work.third.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 安装配置
 */
public class ThirdInstallConfigController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 在第三方服务商网站找到适用的应用后，从服务商网站发起授权请求，授权成功后的额回调地址
     * 需完成业务：通过 临时授权码 获取 永久授权码
     * @param authCode 临时授权码
     * @param expiresIn 过期时间
     * @param state 用于第三方自行校验session，防止跨域攻击
     * @return 响应数据
     */
    public String configPage(String authCode, Integer expiresIn, String state) {
        logger.debug("授权成功后回调：临时授权码 {} 过期时间 {} state {}", authCode, expiresIn, state);
        return "success";
    }
}
