/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.work.inner.client_api.jsapi_ticket.storage;

import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.plugin.wechat.work.inner.client_api.jsapi_ticket.util.JsapiTicketUtil;
import cn.net.wanmo.plugin.wechat.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentData;
import cn.net.wanmo.plugin.wechat.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentReq;
import cn.net.wanmo.plugin.wechat.work.inner.client_api.jsapi_ticket.util.pojo.JsapiTicketForAgentRes;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.Agent;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.log.TokenLog;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.token.TicketToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketTokenForAgent {
    private static Logger logger = LoggerFactory.getLogger(TicketTokenForAgent.class);
    private static Map<String, TicketToken> ticketMap = new HashMap<String, TicketToken>();

    private static String getMapKey(String corpId, String agentId) {
        return corpId + ":" + agentId;
    }

    public static <TicketTokenAgent extends TicketToken> void putTicket(String corpId, String agentId, TicketTokenAgent ticketTokenAgent) {
        ticketTokenAgent.storeToken();
        ticketMap.put(TicketTokenForAgent.getMapKey(corpId, agentId), ticketTokenAgent);
    }

    public static TicketToken getTicket(String corpId, String agentId) {
        return ticketMap.getOrDefault(TicketTokenForAgent.getMapKey(corpId, agentId), new TicketToken());
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> JsapiTicketForAgentRes initToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent) {
        return TicketTokenForAgent.initToken(agent, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, Ticket extends TicketToken> JsapiTicketForAgentRes initToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, Ticket ticket) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentToken = agent.takeToken();
        return TicketTokenForAgent.initToken(corpId, agentId, agentToken, ticket);
    }

    public static <AgentToken extends AccessToken> JsapiTicketForAgentRes initToken(String corpId, String agentId, String agentToken) {
        return TicketTokenForAgent.initToken(corpId, agentId, agentToken, null);
    }

    public static <AgentToken extends AccessToken, Ticket extends TicketToken> JsapiTicketForAgentRes initToken(String corpId, String agentId, String agentToken, Ticket ticket) {
        JsapiTicketForAgentReq req = JsapiTicketForAgentReq.build();
        JsapiTicketForAgentRes result = JsapiTicketUtil.getJsapiTicketForAgent(agentToken, req);
        TicketToken ticketToken = new TicketToken();
        ticketToken.setCorpId(corpId);
        ticketToken.setAgentId(agentId);
        ticketToken.setTokenType(TicketToken.TokenType.jsapi_ticket);
        ticketToken.setCode(String.valueOf(result.getErrCode()));
        ticketToken.setMsg(result.getErrMsg());
        ticketToken.setResTime(result.getResTime());
        if (result.isSuccess()) {
            JsapiTicketForAgentData data = (JsapiTicketForAgentData)result.getData();
            ticketToken.setValue(data.getTicket());
            ticketToken.setExpiresIn(data.getExpiresIn());
        }
        if (Objects.isNull(ticket)) {
            TicketTokenForAgent.putTicket(corpId, agentId, ticketToken);
            logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u6267\u884c\u9ed8\u8ba4\u5b58\u50a8\u5e94\u7528 jsApi \u7968\u636e\u4ee4\u724c ...", (Object)agentId);
        } else {
            ticket.setCorpId(ticketToken.getCorpId());
            ticket.setAgentId(ticketToken.getAgentId());
            ticket.setTokenType(ticketToken.getTokenType());
            ticket.setCode(ticketToken.getCode());
            ticket.setMsg(ticketToken.getMsg());
            ticket.setValue(ticketToken.getValue());
            ticket.setExpiresIn(ticketToken.getExpiresIn());
            ticket.setResTime(ticketToken.getResTime());
            TicketTokenForAgent.putTicket(corpId, agentId, ticket);
            logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u6267\u884c\u81ea\u5b9a\u4e49\u5b58\u50a8\u5e94\u7528 jsApi \u7968\u636e\u4ee4\u724c ...", (Object)agentId);
        }
        TokenLog.put(corpId, agentId, ticketToken.getTokenType().getLabel(), ticketToken, TokenLog.ticketTokenMap);
        return result;
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent) {
        TicketTokenForAgent.runThreadInitToken(agent, null, null, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, Integer residueSecond, Integer waitSecond) {
        TicketTokenForAgent.runThreadInitToken(agent, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, TicketTokenAgent extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, TicketTokenAgent ticketTokenAgent) {
        TicketTokenForAgent.runThreadInitToken(agent, null, null, ticketTokenAgent);
    }

    public static <AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken, TicketTokenAgent extends TicketToken> void runThreadInitToken(Agent<AgentToken, JsApiTicket, JsApiConfigTicket> agent, Integer residueSecond, Integer waitSecond, TicketTokenAgent ticketTokenAgent) {
        String corpId = agent.getCorpId();
        String agentId = agent.getAgentId();
        String agentToken = agent.takeToken();
        TicketTokenForAgent.runThreadInitToken(corpId, agentId, agentToken, residueSecond, waitSecond, ticketTokenAgent);
    }

    public static <AgentToken extends AccessToken> void runThreadInitToken(String corpId, String agentId, String agentToken) {
        TicketTokenForAgent.runThreadInitToken(corpId, agentId, agentToken, null, null, null);
    }

    public static <AgentToken extends AccessToken> void runThreadInitToken(String corpId, String agentId, String agentToken, Integer residueSecond, Integer waitSecond) {
        TicketTokenForAgent.runThreadInitToken(corpId, agentId, agentToken, residueSecond, waitSecond, null);
    }

    public static <AgentToken extends AccessToken, TicketTokenAgent extends TicketToken> void runThreadInitToken(String corpId, String agentId, String agentToken, TicketTokenAgent ticketTokenAgent) {
        TicketTokenForAgent.runThreadInitToken(corpId, agentId, agentToken, null, null, ticketTokenAgent);
    }

    public static <AgentToken extends AccessToken, TicketTokenAgent extends TicketToken> void runThreadInitToken(final String corpId, final String agentId, final String agentToken, final Integer residueSecond, final Integer waitSecond, final TicketTokenAgent ticketTokenAgent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            JsapiTicketForAgentRes result;
                            if ((result = TicketTokenForAgent.initToken(corpId, agentId, agentToken, ticketTokenAgent)).isSuccess()) {
                                String ticketValue = ((JsapiTicketForAgentData)result.getData()).getTicket();
                                Integer expiresIn = ((JsapiTicketForAgentData)result.getData()).getExpiresIn();
                                logger.debug("\u4f01\u4e1a\u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528 jsApi \u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c ticket = {}", new Object[]{agentId, expiresIn, ticketValue});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u4f01\u4e1a\u5e94\u7528ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528 jsApi \u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{agentId, result.getErrCode(), result.getErrMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4f01\u4e1a\u5e94\u7528ID: " + agentId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u5e94\u7528jsapi\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

