package cn.net.wanmo.plugin.wechat.work.inner.pojo;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.token.TicketToken;

import java.io.Serializable;

/**
 * 应用信息
 */
public class Agent<AgentToken extends AccessToken, JsApiTicket extends TicketToken, JsApiConfigTicket extends TicketToken> implements Serializable {
    /** 企业信息 */
    private Corp corp;
    /** 应用 ID */
    private String agentId;
    /** secret是企业应用里面用于保障数据安全的“钥匙”，每一个应用都有一个独立的访问密钥，为了保证数据的安全，secret务必不能泄漏。
     * <pre>
     *     目前 secret 有：
     *
     *     自建应用secret。在管理后台->“应用与小程序”->“应用”->“自建”，点进某个应用，即可看到。
     *     基础应用secret。某些基础应用（如“审批”“打卡”应用），支持通过API进行操作。在管理后台->“应用与小程序”->“应用->”“基础”，点进某个应用，点开“API”小按钮，即可看到。
     * </pre>
     * */
    private String secret;
    /** 应用名称 */
    private String title;
    /** 应用描述 */
    private String desc;
    /** access_token是企业后台去企业微信的后台获取信息时的重要票据，由corpid和secret产生。所有接口在通信时都需要携带此信息用于验证接口的访问权限 */
    private AgentToken agentToken;
    /** jsapi 票据 */
    private JsApiTicket jsApiTicket;
    /** jsapi config 票据 */
    private JsApiConfigTicket jsApiConfigTicket;
    /** 日志打印描述 */
    private String logPrevDesc;
    /** 是否启用，默认 false */
    private boolean enable = false;

    public Agent() {
    }

    public Corp getCorp() {
        return corp;
    }

    public void setCorp(Corp corp) {
        this.corp = corp;
    }

    public String getCorpId() {
        return corp == null ? null : corp.getCorpId();
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public AgentToken getAgentToken() {
        return agentToken;
    }

    public void setAgentToken(AgentToken agentToken) {
        this.agentToken = agentToken;
    }

    public JsApiTicket getJsApiTicket() {
        return jsApiTicket;
    }

    public void setJsApiTicket(JsApiTicket jsApiTicket) {
        this.jsApiTicket = jsApiTicket;
    }

    public JsApiConfigTicket getJsApiConfigTicket() {
        return jsApiConfigTicket;
    }

    public void setJsApiConfigTicket(JsApiConfigTicket jsApiConfigTicket) {
        this.jsApiConfigTicket = jsApiConfigTicket;
    }

    public String getLogPrevDesc() {
        if (StringUtil.isBlank(logPrevDesc)) {
            return corp == null ? title : (corp.getTitle() + "-" + title);
        }

        return logPrevDesc;
    }

    public void setLogPrevDesc(String logPrevDesc) {
        this.logPrevDesc = logPrevDesc;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    /**
     * 获取访问令牌
     * @return 访问令牌
     */
    public String takeToken() {
        if (agentToken == null) {
            return null;
        }

        agentToken.setCorpId(getCorpId());
        agentToken.setAgentId(agentId);
        return agentToken.takeToken();
    }

    public String takeJsApiTicket() {
        if (jsApiTicket == null) {
            return null;
        }

        jsApiTicket.setCorpId(getCorpId());
        jsApiTicket.setAgentId(agentId);

        return jsApiTicket.takeToken();
    }

    public String takeJsApiConfigTicket() {
        if (jsApiConfigTicket == null) {
            return null;
        }

        jsApiConfigTicket.setCorpId(getCorpId());
        jsApiConfigTicket.setAgentId(agentId);

        return jsApiConfigTicket.takeToken();
    }
}
