package cn.net.wanmo.plugin.wechat.work.inner.pojo.log;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.work.pojo.Token;
import com.google.common.collect.Lists;

import java.util.*;

/**
 * Token 日志记录
 * 在执行获取令牌的线程时，会在内存中记录 指定数量 令牌获取的日志信息；
 */
public class TokenLog {
    /**
     * 通讯录令牌的记录 <br/>
     * key: corpId
     * value: list
     */
    public static Map<String, List<TokenLog>> addressBookTokenMap = new HashMap<>();
    /**
     * 应用令牌的记录 <br/>
     * key: corpId-agentId
     * value: list
     */
    public static Map<String, List<TokenLog>> agentTokenMap = new HashMap<>();
    /**
     * 前端票据的记录 <br/>
     * key: corpId-agentId
     * value: list
     */
    public static Map<String, List<TokenLog>> ticketTokenMap = new HashMap<>();
    /**
     * 前端票据配置的记录 <br/>
     * key: corpId-agentId
     * value: list
     */
    public static Map<String, List<TokenLog>> ticketConfigTokenMap = new HashMap<>();

    /**
     * 每个令牌类型保存日志的最多个数
     */
    private static int maxSize = 6;

    /**
     * 获取令牌日志
     *
     * @param corpId  企业ID
     * @param agentId 应用ID 注：获取通讯录令牌则传 null
     * @param map     令牌
     * @return 日志集合
     */
    public static List<TokenLog> get(String corpId, String agentId, Map<String, List<TokenLog>> map) {
        List<TokenLog> list = map.getOrDefault(getKey(corpId, agentId), Lists.newArrayList());
        Collections.reverse(list);
        return list;
    }


    /**
     * 添加 token 日志;
     *
     * @param corpId    企业ID
     * @param agentId   应用ID
     * @param tokenType 令牌类型
     * @param token     令牌
     * @param map       待保存的令牌类型的集合
     */
    public static void put(String corpId, String agentId, String tokenType, Token token, Map<String, List<TokenLog>> map) {
        List<TokenLog> list = map.getOrDefault(getKey(corpId, agentId), Lists.newArrayList());

        { // 添加日志
            TokenLog log = new TokenLog();
            log.setCorpId(corpId);
            log.setAgentId(agentId);
            log.setTokenType(tokenType);
            log.setTokenValue(token.getValue());
            log.setErrCode(token.getCode());
            log.setErrMsg(token.getMsg());
            log.setResTime(DateUtil.formatDayTime(new Date(token.getResTime())));
            list.add(log);
        }

        { // 日志数量控制
            int size = list.size();
            for (int i = 0; i < size - maxSize; i++) {
                list.remove(0);
            }
        }

        map.put(getKey(corpId, agentId), list);
    }

    private static String getKey(String corpId, String agentId) {
        if (StringUtil.isBlank(agentId)) {
            return corpId;
        }

        return corpId + "-" + agentId;
    }

    /**
     * 企业ID
     */
    private String corpId;
    /**
     * 应用ID
     */
    private String agentId;
    /**
     * 令牌类型
     */
    private String tokenType;
    /**
     * 令牌值
     */
    private String tokenValue;
    /**
     * 响应时间
     */
    private String resTime;
    /**
     * 错误码
     */
    private String errCode;
    /**
     * 错误消息
     */
    private String errMsg;

    public TokenLog() {
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenValue() {
        return tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getResTime() {
        return resTime;
    }

    public void setResTime(String resTime) {
        this.resTime = resTime;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
