package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.department.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONObject;

public class DeptCreateReq extends BaseReq {
    /**
     * 生成请求体
     *
     * @param dept 部门信息
     * @return 请求体
     */
    public static DeptCreateReq build(Dept dept) {
        DeptCreateReq req = new DeptCreateReq();
        req.setDept(dept);
        return req;
    }


    @Override
    public String toBody() {
        JSONObject params = new JSONObject();

        params.put("name", dept.getName());
        params.put("name_en", dept.getNameEn());
        params.put("parentid", dept.getParentId());
        params.put("order", dept.getOrder());
        params.put("id", dept.getId());

        return params.toJSONString();
    }

    // ===============================================================================
    private Dept dept;

    public DeptCreateReq() {
        this.dept = new Dept();
    }

    public Dept getDept() {
        return dept;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
    }

    // ===============================================================================
    public Dept newDept() {
        return new Dept();
    }

    public class Dept {
        /**
         * 非必填：部门id，32位整型，指定时必须大于1。若不填该参数，将自动生成id
         */
        private String id;
        /**
         * 必填：父部门id，32位整型
         */
        private String parentId;
        /**
         * 必填：部门名称。同一个层级的部门名称不能重复。长度限制为1~64个UTF-8字符，字符不能包括\:*?"<>｜
         */
        private String name;
        /**
         * 非必填：英文名称。同一个层级的部门名称不能重复。需要在管理后台开启多语言支持才能生效。长度限制为1~64个字符，字符不能包括\:*?"<>｜
         */
        private String nameEn;
        /**
         * 非必填：在父部门中的次序值。order值大的排序靠前。有效的值范围是[0, 2^32)
         */
        private int order;

        public Dept() {
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentId() {
            return parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameEn() {
            return nameEn;
        }

        public void setNameEn(String nameEn) {
            this.nameEn = nameEn;
        }

        public int getOrder() {
            return order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }
}
