package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.tag;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.work.inner.CommonUtil;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.tag.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 通讯录管理：标签管理
 */
public class TagUtil {
    private static Logger logger = LoggerFactory.getLogger(TagUtil.class);

    /**
     * 创建标签 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagCreateRes create(String addressBookToken, TagCreateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 创建标签: ");

        req.setBody(req.toBody());
        TagCreateRes res = new TagCreateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 更新标签名字 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagUpdateRes update(String addressBookToken, TagUpdateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 更新标签名字: ");

        req.setBody(req.toBody());
        TagUpdateRes res = new TagUpdateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 删除标签 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagDeleteRes delete(String addressBookToken, TagDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 删除标签: ");

        req.setBody(null);
        TagDeleteRes res = new TagDeleteRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/delete?access_token=ACCESS_TOKEN&tagid=TAGID";
        url = url.replace("ACCESS_TOKEN", addressBookToken).replace("TAGID", String.valueOf(req.getTagId()));

        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 获取标签成员 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagGetRes get(String addressBookToken, TagGetReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 获取标签成员: ");

        req.setBody(null);
        TagGetRes res = new TagGetRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/get?access_token=ACCESS_TOKEN&tagid=TAGID";
        url = url.replace("ACCESS_TOKEN", addressBookToken).replace("TAGID", String.valueOf(req.getTagId()));

        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 增加标签成员 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagAddUsersRes addUsers(String addressBookToken, TagAddUsersReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 增加标签成员: ");

        req.setBody(req.toBody());
        TagAddUsersRes res = new TagAddUsersRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/addtagusers?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }


    /**
     * 删除标签成员 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @param req              请求体
     * @return 响应结果
     */
    @Deprecated
    public static TagDelUsersRes delUsers(String addressBookToken, TagDelUsersReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 删除标签成员: ");

        req.setBody(req.toBody());
        TagDelUsersRes res = new TagDelUsersRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/deltagusers?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 获取标签列表 <br/>
     *
     * @param addressBookToken 通讯录令牌
     * @return 响应结果
     */
    @Deprecated
    public static TagListRes list(String addressBookToken) {
        String msgPre = CommonUtil.getInterfaceTitle("通讯录管理 标签管理 获取标签列表: ");

        TagListReq req = new TagListReq();
        TagListRes res = new TagListRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/list?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);

        return SendUtil.get(msgPre, url, req, res, null);
    }
}
