package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.tag.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONObject;

import java.util.List;

/**
 * 增加标签成员
 */
public class TagAddUsersReq extends BaseReq {
    /**
     * 构建请求体
     *
     * @param tagId     标签ID
     * @param userList  企业成员ID列表，注意：userlist、partylist不能同时为空，单次请求个数不超过1000
     * @param partyList 企业部门ID列表，注意：userlist、partylist不能同时为空，单次请求个数不超过100
     * @return 请求体
     */
    public static TagAddUsersReq build(Integer tagId, List<String> userList, List<Integer> partyList) {
        TagAddUsersReq req = new TagAddUsersReq();
        req.setTagId(tagId);
        req.setUserList(userList);
        req.setPartyList(partyList);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("tagid", this.tagId);
        params.put("userlist", this.userList);
        params.put("partylist", this.partyList);

        return params.toJSONString();
    }

    // ------------------------------------ 请求属性 ------------------------------------

    /**
     * 标签ID <br/>
     * 必填 <br/>
     */
    private Integer tagId;
    /**
     * 企业成员ID列表<br/>
     * 非必填 <br/>
     * 企业成员ID列表，注意：userlist、partylist不能同时为空，单次请求个数不超过1000
     */
    private List<String> userList;
    /**
     * 企业部门ID列表<br/>
     * 非必填 <br/>
     * 企业部门ID列表，注意：userlist、partylist不能同时为空，单次请求个数不超过100
     */
    private List<Integer> partyList;

    public TagAddUsersReq() {
    }

    public Integer getTagId() {
        return tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }


    public List<String> getUserList() {
        return userList;
    }

    public void setUserList(List<String> userList) {
        this.userList = userList;
    }

    public List<Integer> getPartyList() {
        return partyList;
    }

    public void setPartyList(List<Integer> partyList) {
        this.partyList = partyList;
    }
}
