package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONObject;

public class UserGetIdByEmailReq extends BaseReq {

    public static UserGetIdByEmailReq build(String email) {
        return build(email, EmailType.enterprise);
    }

    public static UserGetIdByEmailReq build(String email, EmailType emailType) {
        UserGetIdByEmailReq req = new UserGetIdByEmailReq();
        req.setEmail(email);
        req.setEmailType(emailType);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("email", getEmail());
        params.put("email_type", getEmailType().value);
        return params.toJSONString();
    }

    private String email;
    private EmailType emailType;

    public UserGetIdByEmailReq() {
        this.emailType = EmailType.enterprise;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailType getEmailType() {
        return emailType;
    }

    public void setEmailType(EmailType emailType) {
        this.emailType = emailType;
    }

    public enum EmailType {
        enterprise(1, "企业邮箱"),
        personal(2, "个人邮箱");

        private final Integer value;
        private final String label;

        EmailType(Integer value, String label) {
            this.value = value;
            this.label = label;
        }

        public Integer getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }
}
