package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONObject;

public class UserListIdReq extends BaseReq {

    /**
     * 生成请求体
     * @return 请求体
     */
    public static UserListIdReq build() {
        return build(null, null);
    }

    /**
     * 生成请求体
     * @param limit 预期请求的数据量
     * @return 请求体
     */
    public static UserListIdReq build(Integer limit) {
        return build(limit, null);
    }

    /**
     * 生成请求体
     * @param limit 预期请求的数据量
     * @param cursor 分页查询的游标
     * @return 请求体
     */
    public static UserListIdReq build(Integer limit, String cursor) {
        UserListIdReq req = new UserListIdReq();
        req.setLimit(limit);
        req.setCursor(cursor);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("cursor", getCursor());
        params.put("limit", getLimit());
        return params.toJSONString();
    }

    /** 访问令牌 */
    private String accessToken;

    /** 用于分页查询的游标，字符串类型，由上一次调用返回，首次调用不填 */
    private String cursor;
    /** 分页，预期请求的数据量，取值范围 1 ~ 10000 */
    private Integer limit;

    public UserListIdReq() {
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}
