package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.department.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

public class DeptSimpleListRes extends WechatBaseRes<DeptSimpleListData> {
    @Override
    protected void initData() {
        this.data = new DeptSimpleListData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        {
            JSONArray array = object.getJSONArray("department_id");
            if (array == null || array.isEmpty()) {
            } else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject temp = array.getJSONObject(i);

                    DeptSimpleListData.Dept dept = this.data.newDept();
                    dept.setId(temp.getString("id"));
                    dept.setParentId(temp.getString("parentid"));
                    dept.setOrder(temp.getIntValue("order"));

                    this.data.getDepts().add(dept);
                }
            }
        }

        return super.parseObj(resBody);
    }

}
