/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user;

import cn.net.wanmo.common.send.BaseReq;
import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.work.inner.CommonUtil;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserAuthSuccReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserAuthSuccRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserBatchDeleteReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserBatchDeleteRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserConvertToOpenidReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserConvertToOpenidRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserConvertToUseridReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserConvertToUseridRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserCreateReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserCreateRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserDeleteReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserDeleteRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetIdByEmailReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetIdByEmailRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetIdByMobileReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetIdByMobileRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserGetRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserListIdReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserListIdRes;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserUpdateReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.user.pojo.UserUpdateRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtil {
    private static Logger logger = LoggerFactory.getLogger(UserUtil.class);

    public static UserCreateRes createUser(String addressBookToken, UserCreateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u521b\u5efa\u6210\u5458: ");
        req.setBody(req.toBody());
        UserCreateRes res = new UserCreateRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserCreateRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    @Deprecated
    public static UserGetRes getUser(String addressBookToken, UserGetReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u8bfb\u53d6\u6210\u5458: ");
        UserGetRes res = new UserGetRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken).replace("USERID", req.getUserId());
        return (UserGetRes)SendUtil.get((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserUpdateRes updateUser(String addressBookToken, UserUpdateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u66f4\u65b0\u6210\u5458: ");
        req.setBody(req.toBody());
        UserUpdateRes res = new UserUpdateRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserUpdateRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserDeleteRes deleteUser(String addressBookToken, UserDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u5220\u9664\u6210\u5458: ");
        UserDeleteRes res = new UserDeleteRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("USERID", StringUtil.isBlank((CharSequence)req.getUserid()) ? "" : req.getUserid());
        return (UserDeleteRes)SendUtil.get((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserBatchDeleteRes batchDeleteUser(String addressBookToken, UserBatchDeleteReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u6279\u91cf\u5220\u9664\u6210\u5458: ");
        req.setBody(req.toBody());
        UserBatchDeleteRes res = new UserBatchDeleteRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserBatchDeleteRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static <AddressBookToken extends AccessToken> void simpleListByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    public static <AddressBookToken extends AccessToken> void listByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    public static UserConvertToOpenidRes convertToOpenid(String addressBookToken, UserConvertToOpenidReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 userid\u8f6copenid: ");
        req.setBody(req.toBody());
        UserConvertToOpenidRes res = new UserConvertToOpenidRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserConvertToOpenidRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserConvertToUseridRes convertToUserid(String addressBookToken, UserConvertToUseridReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 openid\u8f6cuserid: ");
        req.setBody(req.toBody());
        UserConvertToUseridRes res = new UserConvertToUseridRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserConvertToUseridRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserAuthSuccRes authSucc(String addressBookToken, UserAuthSuccReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u767b\u5f55\u4e8c\u6b21\u9a8c\u8bc1: ");
        UserAuthSuccRes res = new UserAuthSuccRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/authsucc?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        url = url.replace("USERID", StringUtil.isBlank((CharSequence)req.getUserid()) ? "" : req.getUserid());
        return (UserAuthSuccRes)SendUtil.get((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static <AddressBookToken extends AccessToken> void batchInvite() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/invite?access_token=ACCESS_TOKEN";
    }

    public static <AddressBookToken extends AccessToken> void getJoinQrcode() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/corp/get_join_qrcode?access_token=ACCESS_TOKEN&size_type=SIZE_TYPE";
    }

    public static UserGetIdByMobileRes getUseridByMobile(String addressBookToken, UserGetIdByMobileReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u624b\u673a\u53f7\u83b7\u53d6userid: ");
        req.setBody(req.toBody());
        UserGetIdByMobileRes res = new UserGetIdByMobileRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserGetIdByMobileRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserGetIdByEmailRes getUseridByEmail(String addressBookToken, UserGetIdByEmailReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u90ae\u7bb1\u83b7\u53d6userid: ");
        req.setBody(req.toBody());
        UserGetIdByEmailRes res = new UserGetIdByEmailRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get_userid_by_email?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserGetIdByEmailRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }

    public static UserListIdRes listId(String addressBookToken, UserListIdReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("\u901a\u8baf\u5f55\u7ba1\u7406 \u83b7\u53d6\u6210\u5458ID\u5217\u8868: ");
        req.setBody(req.toBody());
        UserListIdRes res = new UserListIdRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list_id?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", addressBookToken);
        return (UserListIdRes)SendUtil.post((String)msgPre, (String)url, (BaseReq)req, (BaseRes)res, null);
    }
}

