package cn.net.wanmo.plugin.wechat.work.inner.server_api.address_book.tag.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.plugin.wechat.work.inner.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

/**
 * 获取标签成员
 */
public class TagGetRes extends WechatBaseRes<TagGetData> {
    @Override
    protected void initData() {
        this.data = new TagGetData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);


        this.data.setTagName(object.getString("tagname"));

        { // 成员列表
            JSONArray array = object.getJSONArray("userlist");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject temp = array.getJSONObject(i);

                    TagGetData.TagUser tagUser = this.data.newTagUser();
                    tagUser.setUserId(temp.getString("userid"));
                    tagUser.setUserName(temp.getString("name"));

                    this.data.getUserList().add(tagUser);
                }
            }
        }

        { // 部门id列表
            JSONArray array = object.getJSONArray("partylist");
            if (array == null || array.isEmpty()) {
            } else {
                for (int i = 0; i < array.size(); i++) {
                    Integer partyId = array.getInteger(i);
                    this.data.getPartyList().add(partyId);
                }
            }
        }

        return super.parseObj(resBody);
    }

}
