package cn.net.wanmo.plugin.wechat.work.inner.server_api.message;

import cn.net.wanmo.common.send.HttpJdkSender;
import cn.net.wanmo.plugin.wechat.work.inner.CommonUtil;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo.WebhookMessageReq;
import cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo.WebhookMessageRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 群机器人
 */
public class WebhookUtil {

    private static Logger logger = LoggerFactory.getLogger(WebhookUtil.class);


    /**
     * 发送消息
     *
     * @param url 群机器人 webhook 地址
     * @param req 请求体
     * @return 响应结果
     */
    public static WebhookMessageRes sendMessage(String url, WebhookMessageReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("群机器人 发送应消息: ");

        req.setBody(req.toBody());
        WebhookMessageRes res = new WebhookMessageRes();

        return HttpJdkSender.post(msgPre, url, req, res);
    }
}
