package cn.net.wanmo.plugin.wechat.work.inner.server_api.message.pojo;

import com.alibaba.fastjson2.JSONObject;

/**
 * 文本类型
 */
public class WebhookTextMessageReq extends WebhookMessageReq{

    public static WebhookTextMessageReq build(String content) {
        WebhookTextMessageReq req = new WebhookTextMessageReq();
        req.getText().setContent(content);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject params = new JSONObject();
        params.put("msgtype", getMsgType().name());
        params.put("text", getText().toJSONObject());
        return params.toJSONString();
    }

    /** 消息内容 */
    private Text text = new Text();

    public WebhookTextMessageReq() {
        this.msgType = MsgType.text;
    }

    public Text getText() {
        return text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public class Text {

        /** 是	文本内容，最长不超过2048个字节，必须是utf8编码 */
        private String content;

        public Text() {
        }

        public Text(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("content", getContent());
            return object;
        }
    }
}
