/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.work.third.app_empower;

import cn.net.wanmo.common.http.jdk.HttpJdkUtil;
import cn.net.wanmo.common.http.jdk.pojo.ResData;
import cn.net.wanmo.common.result.HttpResult;
import cn.net.wanmo.plugin.wechat.work.third.util.AccessTokenUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBookUtil {
    private static Logger logger = LoggerFactory.getLogger(AddressBookUtil.class);

    public static JSONObject getSuiteAccessToken(String suiteId, String suiteSecret, String suiteTicket) {
        return AccessTokenUtil.getSuiteAccessToken(suiteId, suiteSecret, suiteTicket);
    }

    public static JSONObject getPreAuthCode(String suiteAccessToken) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=SUITE_ACCESS_TOKEN";
        url = url.replace("SUITE_ACCESS_TOKEN", suiteAccessToken);
        JSONObject jsonObjectRes = new JSONObject();
        HttpResult result = HttpJdkUtil.get((String)url).send();
        if (result.isSuccess()) {
            String body = ((ResData)result.getData()).getBody();
            logger.debug("\u83b7\u53d6 pre_auth_code \u8bf7\u6c42 http \u6210\u529f\uff1a{}", (Object)body);
            jsonObjectRes = JSON.parseObject((String)body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            String preAuthCode = jsonObjectRes.getString("pre_auth_code");
            Integer expiresIn = jsonObjectRes.getInteger("expires_in");
            if (errcode == 0) {
                logger.debug("\u83b7\u53d6 pre_auth_code \u6210\u529f\uff1a {}\uff0c\u6709\u6548\u65f6\u5e38\uff1a {}", (Object)preAuthCode, (Object)expiresIn);
            } else {
                logger.debug("\u83b7\u53d6 pre_auth_code \u5931\u8d25\uff1a {}\uff0c\u9519\u8bef\u7801\uff1a {}", (Object)errmsg, (Object)errcode);
            }
        } else {
            jsonObjectRes.put((Object)"errcode", (Object)-1);
            jsonObjectRes.put((Object)"errmsg", (Object)result.getMsg());
            logger.error("\u83b7\u53d6 pre_auth_code \u8bf7\u6c42 http \u5931\u8d25\uff1a{}", (Object)result.getMsg());
        }
        return jsonObjectRes;
    }

    public static JSONObject setSessionInfo(String suiteAccessToken, String preAuthCode, String[] suiteIds, int authType) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=SUITE_ACCESS_TOKEN";
        url = url.replace("SUITE_ACCESS_TOKEN", suiteAccessToken);
        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put((Object)"pre_auth_code", (Object)preAuthCode);
        JSONObject sessionInfo = new JSONObject();
        sessionInfo.put((Object)"appid", (Object)new String[0]);
        sessionInfo.put((Object)"auth_type", (Object)authType);
        jsonObjectReq.put((Object)"session_info", (Object)sessionInfo);
        System.out.println(jsonObjectReq.toJSONString(new JSONWriter.Feature[0]));
        HttpResult result = HttpJdkUtil.post((String)url).body(jsonObjectReq.toJSONString(new JSONWriter.Feature[0])).send();
        JSONObject jsonObjectRes = new JSONObject();
        if (result.isSuccess()) {
            String body = ((ResData)result.getData()).getBody();
            logger.debug("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e \u8bf7\u6c42 http \u6210\u529f\uff1a{}", (Object)body);
            jsonObjectRes = JSON.parseObject((String)body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            if (errcode == 0) {
                logger.debug("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e \u6210\u529f ");
            } else {
                logger.debug("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e \u5931\u8d25\uff1a {}\uff0c\u9519\u8bef\u7801\uff1a {}", (Object)errmsg, (Object)errcode);
            }
        } else {
            jsonObjectRes.put((Object)"errcode", (Object)-1);
            jsonObjectRes.put((Object)"errmsg", (Object)result.getMsg());
            logger.error("\u8bbe\u7f6e\u6388\u6743\u914d\u7f6e \u8bf7\u6c42 http \u5931\u8d25\uff1a{}", (Object)result.getMsg());
        }
        return jsonObjectRes;
    }
}

