/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.work.third.util;

import cn.net.wanmo.common.http.jdk.HttpJdkUtil;
import cn.net.wanmo.common.http.jdk.pojo.ResData;
import cn.net.wanmo.common.result.HttpResult;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenUtil.class);

    public static JSONObject getProviderAccessToken(String corpId, String providerSecret) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token";
        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put((Object)"corpid", (Object)corpId);
        jsonObjectReq.put((Object)"provider_secret", (Object)providerSecret);
        JSONObject jsonObjectRes = new JSONObject();
        return jsonObjectRes;
    }

    public static JSONObject getSuiteAccessToken(String suiteId, String suiteSecret, String suiteTicket) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token";
        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put((Object)"suite_id", (Object)suiteId);
        jsonObjectReq.put((Object)"suite_secret", (Object)suiteSecret);
        jsonObjectReq.put((Object)"suite_ticket", (Object)suiteTicket);
        JSONObject jsonObjectRes = new JSONObject();
        HttpResult result = HttpJdkUtil.post((String)url).body(jsonObjectReq.toJSONString(new JSONWriter.Feature[0])).send();
        if (result.isSuccess()) {
            String body = ((ResData)result.getData()).getBody();
            logger.debug("\u83b7\u53d6 suite_access_token \u8bf7\u6c42 http \u6210\u529f\uff1a{}", (Object)body);
            jsonObjectRes = JSON.parseObject((String)body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            String suiteAccessToken = jsonObjectRes.getString("suite_access_token");
            Integer expiresIn = jsonObjectRes.getInteger("expires_in");
            if (errcode == 0) {
                logger.debug("\u83b7\u53d6 suite_access_token \u6210\u529f\uff1a {}\uff0c\u6709\u6548\u65f6\u5e38\uff1a {}", (Object)suiteAccessToken, (Object)expiresIn);
            } else {
                logger.debug("\u83b7\u53d6 suite_access_token \u5931\u8d25\uff1a {}\uff0c\u9519\u8bef\u7801\uff1a {}", (Object)errmsg, (Object)errcode);
            }
        } else {
            jsonObjectRes.put((Object)"errcode", (Object)-1);
            jsonObjectRes.put((Object)"errmsg", (Object)result.getMsg());
            logger.error("\u83b7\u53d6 suite_access_token \u8bf7\u6c42 http \u5931\u8d25\uff1a{}", (Object)result.getMsg());
        }
        return jsonObjectRes;
    }
}

